/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.ContextFinder;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVariableDeclarationEvaluator
extends AbstractPHPGoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public ClassVariableDeclarationEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        TypeContext context;
        ClassVariableDeclarationGoal typedGoal = (ClassVariableDeclarationGoal)this.goal;
        IType[] types = typedGoal.getTypes();
        if (types == null) {
            context = (TypeContext)typedGoal.getContext();
            types = PHPTypeInferenceUtils.getModelElements(context.getInstanceType(), (ISourceModuleContext)context);
        }
        if (types == null) {
            return null;
        }
        context = typedGoal.getContext();
        IModelAccessCache cache = null;
        if (context instanceof IModelCacheContext) {
            cache = ((IModelCacheContext)context).getCache();
        }
        String variableName = typedGoal.getVariableName();
        LinkedList<IGoal> subGoals = new LinkedList<IGoal>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                IType type = iTypeArray[n2];
                try {
                    ITypeHierarchy hierarchy = null;
                    if (cache != null) {
                        hierarchy = cache.getSuperTypeHierarchy(type, null);
                    }
                    IField[] fields = PHPModelUtils.getTypeHierarchyField(type, hierarchy, variableName, true, null);
                    HashSet<IType> fieldDeclaringTypeSet = new HashSet<IType>();
                    IField[] iFieldArray = fields;
                    int n3 = fields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block16: {
                            IField field = iFieldArray[n4];
                            IType declaringType = field.getDeclaringType();
                            if (declaringType != null) {
                                fieldDeclaringTypeSet.add(declaringType);
                                ISourceModule sourceModule = declaringType.getSourceModule();
                                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                                TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass(moduleDeclaration, declaringType);
                                if (typeDeclaration != null && field instanceof SourceRefElement) {
                                    SourceRefElement sourceRefElement = (SourceRefElement)field;
                                    ISourceRange sourceRange = sourceRefElement.getSourceRange();
                                    ClassDeclarationSearcher searcher = new ClassDeclarationSearcher(sourceModule, typeDeclaration, sourceRange.getOffset(), sourceRange.getLength(), null);
                                    try {
                                        moduleDeclaration.traverse((ASTVisitor)searcher);
                                        if (searcher.getResult() != null) {
                                            subGoals.add((IGoal)new ExpressionTypeGoal(searcher.getContext(), searcher.getResult()));
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!DLTKCore.DEBUG) break block16;
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        ++n4;
                    }
                    if (subGoals.size() == 0) {
                        this.getGoalFromStaticDeclaration(variableName, subGoals, type);
                    }
                    fieldDeclaringTypeSet.remove(type);
                    if (subGoals.size() == 0 && !fieldDeclaringTypeSet.isEmpty()) {
                        for (IType fieldDeclaringType : fieldDeclaringTypeSet) {
                            this.getGoalFromStaticDeclaration(variableName, subGoals, fieldDeclaringType);
                        }
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block17;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.resolveMagicClassVariableDeclaration(types, variableName, cache);
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    protected void getGoalFromStaticDeclaration(String variableName, List<IGoal> subGoals, IType type) throws ModelException {
        block3: {
            ISourceModule sourceModule = type.getSourceModule();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            TypeDeclaration typeDeclaration = PHPModelUtils.getNodeByClass(moduleDeclaration, type);
            ClassDeclarationSearcher searcher = new ClassDeclarationSearcher(sourceModule, typeDeclaration, 0, 0, variableName);
            try {
                moduleDeclaration.traverse((ASTVisitor)searcher);
                Map<ASTNode, IContext> staticDeclarations = searcher.getStaticDeclarations();
                for (ASTNode node : staticDeclarations.keySet()) {
                    subGoals.add((IGoal)new ExpressionTypeGoal(staticDeclarations.get(node), node));
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private void resolveMagicClassVariableDeclaration(IType[] types, String variableName, IModelAccessCache cache) {
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            this.resolveMagicClassVariableDeclaration(variableName, type, cache);
            try {
                if (this.evaluated.isEmpty() && type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
                    ITypeHierarchy hierarchy = null;
                    if (cache != null) {
                        hierarchy = cache.getSuperTypeHierarchy(type, null);
                    }
                    IType[] superClasses = PHPModelUtils.getSuperClasses(type, hierarchy);
                    int i = 0;
                    while (i < superClasses.length) {
                        IType superClass = superClasses[i];
                        this.resolveMagicClassVariableDeclaration(variableName, superClass, cache);
                        ++i;
                    }
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    protected void resolveMagicClassVariableDeclaration(String variableName, IType type, IModelAccessCache cache) {
        PHPDocBlock docBlock = PHPModelUtils.getDocBlock(type);
        if (docBlock != null) {
            PHPDocTag[] pHPDocTagArray = docBlock.getTags();
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName;
                PHPDocTag tag = pHPDocTagArray[n2];
                int tagKind = tag.getTagKind();
                if ((tagKind == 30 || tagKind == 31 || tagKind == 32) && (typeName = this.getTypeBinding(variableName, tag)) != null) {
                    Object resolved = PHPSimpleTypes.fromString(typeName);
                    if (resolved == null) {
                        resolved = new PHPClassType(typeName);
                    }
                    this.evaluated.add((IEvaluatedType)resolved);
                }
                ++n2;
            }
        }
    }

    private String getTypeBinding(String variableName, PHPDocTag docTag) {
        String[] split = docTag.getValue().trim().split("\\s+");
        if (split.length < 2) {
            return null;
        }
        return split[1].equals(variableName) ? split[0] : null;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassDeclarationSearcher
    extends ContextFinder {
        private TypeDeclaration typeDeclaration;
        private ASTNode result;
        private IContext context;
        private int offset;
        private int length;
        private String variableName;
        private Map<ASTNode, IContext> staticDeclarations;

        public ClassDeclarationSearcher(ISourceModule sourceModule, TypeDeclaration typeDeclaration, int offset, int length, String variableName) {
            super(sourceModule);
            this.typeDeclaration = typeDeclaration;
            this.offset = offset;
            this.length = length;
            this.variableName = variableName;
            this.staticDeclarations = new HashMap<ASTNode, IContext>();
        }

        public ASTNode getResult() {
            return this.result;
        }

        public Map<ASTNode, IContext> getStaticDeclarations() {
            return this.staticDeclarations;
        }

        @Override
        public IContext getContext() {
            return this.context;
        }

        public boolean visit(Statement e) throws Exception {
            PHPFieldDeclaration phpFieldDecl;
            if (this.typeDeclaration.sourceStart() < e.sourceStart() && this.typeDeclaration.sourceEnd() > e.sourceEnd() && e instanceof PHPFieldDeclaration && (phpFieldDecl = (PHPFieldDeclaration)e).getDeclarationStart() == this.offset && phpFieldDecl.sourceEnd() - phpFieldDecl.getDeclarationStart() == this.length) {
                this.result = ((PHPFieldDeclaration)e).getVariableValue();
                this.context = (IContext)this.contextStack.peek();
            }
            return this.visitGeneral((ASTNode)e);
        }

        public boolean visit(Expression e) throws Exception {
            if (this.typeDeclaration.sourceStart() < e.sourceStart() && this.typeDeclaration.sourceEnd() > e.sourceEnd() && e instanceof Assignment) {
                if (e.sourceStart() == this.offset && e.sourceEnd() - e.sourceStart() == this.length) {
                    this.result = ((Assignment)e).getValue();
                    this.context = (IContext)this.contextStack.peek();
                } else if (this.variableName != null) {
                    Expression field;
                    FieldAccess fieldAccess;
                    Expression dispatcher;
                    Assignment assignment = (Assignment)e;
                    Expression left = assignment.getVariable();
                    Expression right = assignment.getValue();
                    if (left instanceof StaticFieldAccess) {
                        Expression field2;
                        StaticFieldAccess fieldAccess2 = (StaticFieldAccess)left;
                        Expression dispatcher2 = fieldAccess2.getDispatcher();
                        if (dispatcher2 instanceof TypeReference && "self".equals(((TypeReference)dispatcher2).getName()) && (field2 = fieldAccess2.getField()) instanceof VariableReference && this.variableName.equals(((VariableReference)field2).getName())) {
                            this.staticDeclarations.put((ASTNode)right, (IContext)this.contextStack.peek());
                        }
                    } else if (left instanceof FieldAccess && (dispatcher = (fieldAccess = (FieldAccess)left).getDispatcher()) instanceof VariableReference && "$this".equals(((VariableReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof SimpleReference && this.variableName.equals(String.valueOf('$') + ((SimpleReference)field).getName())) {
                        this.staticDeclarations.put((ASTNode)right, (IContext)this.contextStack.peek());
                    }
                }
            }
            return this.visitGeneral((ASTNode)e);
        }

        public boolean visitGeneral(ASTNode e) throws Exception {
            return e.sourceStart() <= this.offset || this.variableName != null;
        }
    }
}

