/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.php.internal.core.util.WeakObject;

public class WeakCollection
implements Collection {
    private Collection refrencedCollection;

    public WeakCollection(int capacity) {
        this.refrencedCollection = new ArrayList(capacity);
    }

    public WeakCollection() {
        this.refrencedCollection = new ArrayList();
    }

    public int size() {
        this.removeUnReferencedObjects();
        return this.refrencedCollection.size();
    }

    public boolean isEmpty() {
        this.removeUnReferencedObjects();
        return this.refrencedCollection.isEmpty();
    }

    public boolean contains(Object o) {
        return this.refrencedCollection.contains(new WeakObject(o));
    }

    public Iterator iterator() {
        return new WeakIterator();
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a2) {
        this.removeUnReferencedObjects();
        Object[] objects = this.refrencedCollection.toArray();
        if (a2 == null || a2.length < objects.length) {
            a2 = new Object[objects.length];
        }
        int i = 0;
        while (i < objects.length) {
            a2[i] = ((WeakObject)objects[i]).get();
            ++i;
        }
        return a2;
    }

    public boolean add(Object o) {
        WeakObject weakObject = new WeakObject(o);
        return this.refrencedCollection.add(weakObject);
    }

    public boolean remove(Object o) {
        WeakObject weakObject = new WeakObject(o);
        return this.refrencedCollection.remove(weakObject);
    }

    public boolean containsAll(Collection c) {
        boolean containsAll = true;
        if (c instanceof WeakCollection) {
            containsAll = this.refrencedCollection.containsAll(((WeakCollection)c).refrencedCollection);
        } else {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                containsAll = false;
            }
        }
        return containsAll;
    }

    public boolean addAll(Collection c) {
        boolean modified = false;
        if (c instanceof WeakCollection) {
            modified = this.refrencedCollection.addAll(((WeakCollection)c).refrencedCollection);
        } else {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (!this.add(it.next())) continue;
                modified = true;
            }
        }
        return modified;
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        if (c instanceof WeakCollection) {
            modified = this.refrencedCollection.removeAll(((WeakCollection)c).refrencedCollection);
        } else {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (!this.remove(it.next())) continue;
                modified = true;
            }
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        boolean modified = false;
        if (c instanceof WeakCollection) {
            modified = this.refrencedCollection.retainAll(((WeakCollection)c).refrencedCollection);
        } else {
            for (Object o : this) {
                if (c.contains(o)) continue;
                modified = this.remove(o);
            }
        }
        return modified;
    }

    public void clear() {
        this.refrencedCollection.clear();
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o instanceof WeakCollection && this.refrencedCollection.equals(((WeakCollection)o).refrencedCollection)) {
            isEqual = true;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.refrencedCollection.hashCode();
    }

    protected void removeUnReferencedObjects() {
        Iterator weakIterator = this.iterator();
        while (weakIterator.hasNext()) {
            weakIterator.next();
        }
    }

    private class WeakIterator
    implements Iterator {
        private Iterator referencedIterator;
        private Object nextObject = null;

        public WeakIterator() {
            this.referencedIterator = WeakCollection.this.refrencedCollection.iterator();
        }

        public boolean hasNext() {
            this.nextObject = this.nextImpl();
            return this.nextObject != null;
        }

        public Object next() {
            if (this.nextObject == null) {
                this.nextObject = this.nextImpl();
            }
            Object rv = this.nextObject;
            this.nextObject = null;
            return rv;
        }

        public void remove() {
            this.referencedIterator.remove();
        }

        private Object nextImpl() {
            while (this.referencedIterator.hasNext()) {
                Object referant = ((WeakObject)this.referencedIterator.next()).get();
                if (referant != null) {
                    return referant;
                }
                this.referencedIterator.remove();
            }
            return null;
        }
    }
}

