/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.pathmapper.IPathEntryFilter;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;
import org.eclipse.php.internal.debug.ui.pathmapper.PathEntrySelectionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PathEntrySelector
implements IPathEntryFilter {
    public PathEntry[] filter(PathEntry[] entries, final VirtualPath remotePath, final IDebugTarget debugTarget) {
        entries = this.removeDuplicate(entries);
        final LinkedList<PathEntry> l = new LinkedList<PathEntry>();
        final PathEntry[] mostMatchEntries = this.getMostMatchEntries(entries, remotePath);
        if (mostMatchEntries.length == 1) {
            l.add(mostMatchEntries[0]);
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    PathEntry entry;
                    Shell shell = Display.getDefault().getActiveShell();
                    if (shell == null) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                            window = windows[0];
                        }
                        if (window != null) {
                            shell = window.getShell();
                        }
                    }
                    if ((entry = PathEntrySelector.this.runFilterDialog(shell, remotePath, mostMatchEntries, debugTarget)) != null) {
                        l.add(entry);
                    }
                }
            };
            if (Display.getCurrent() != null) {
                r.run();
            } else {
                Display.getDefault().syncExec(r);
            }
        }
        return l.toArray(new PathEntry[l.size()]);
    }

    private PathEntry[] removeDuplicate(PathEntry[] entries) {
        HashSet<PathEntry> set = new HashSet<PathEntry>();
        int i = 0;
        while (i < entries.length) {
            set.add(entries[i]);
            ++i;
        }
        return set.toArray(new PathEntry[set.size()]);
    }

    private PathEntry[] getMostMatchEntries(PathEntry[] entries, VirtualPath remotePath) {
        if (remotePath.getSegmentsCount() == 1) {
            return entries;
        }
        HashMap<Integer, ArrayList<PathEntry>> map = new HashMap<Integer, ArrayList<PathEntry>>();
        int mostMatchSegmentsNumber = 1;
        int i = 0;
        while (i < entries.length) {
            ArrayList<PathEntry> list;
            PathEntry pathEntry = entries[i];
            VirtualPath virtualPath = pathEntry.getAbstractPath();
            int matchSegmentsNumber = this.getMatchSegmentsNumber(virtualPath, remotePath);
            if (matchSegmentsNumber > mostMatchSegmentsNumber) {
                mostMatchSegmentsNumber = matchSegmentsNumber;
            }
            if ((list = (ArrayList<PathEntry>)map.get(matchSegmentsNumber)) == null) {
                list = new ArrayList<PathEntry>();
                map.put(matchSegmentsNumber, list);
            }
            list.add(pathEntry);
            ++i;
        }
        List mostMatchList = (List)map.get(mostMatchSegmentsNumber);
        return mostMatchList.toArray(new PathEntry[mostMatchList.size()]);
    }

    private int getMatchSegmentsNumber(VirtualPath virtualPath, VirtualPath remotePath) {
        int i = virtualPath.getSegmentsCount();
        if (i > remotePath.getSegmentsCount()) {
            i = remotePath.getSegmentsCount();
        }
        int result = 0;
        int j = i - 1;
        while (j >= 0) {
            if (virtualPath.getSegments()[j + (virtualPath.getSegmentsCount() - i)].equals(remotePath.getSegments()[j + (remotePath.getSegmentsCount() - i)])) {
                ++result;
            }
            --j;
        }
        return result;
    }

    protected PathEntrySelectionDialog createSelectionDialog(Shell shell, VirtualPath remotePath, PathEntry[] entries) {
        return new PathEntrySelectionDialog(shell, remotePath, entries);
    }

    protected PathEntry runFilterDialog(Shell shell, VirtualPath remotePath, PathEntry[] entries, IDebugTarget debugTarget) {
        PathEntrySelectionDialog selectDialog = this.createSelectionDialog(shell, remotePath, entries);
        if (selectDialog.open() == 0) {
            PathEntry result = selectDialog.getResult();
            if (result != null) {
                return result;
            }
            VirtualPath ignorePath = selectDialog.getIgnoreResult();
            result = new PathEntry(ignorePath, PathEntry.Type.SERVER, null);
            if (debugTarget instanceof PHPDebugTarget) {
                PHPDebugTarget phpDebugTarget = (PHPDebugTarget)debugTarget;
                phpDebugTarget.getContextManager().addToResolveBlacklist(ignorePath, ResolveBlackList.Type.RECURSIVE);
            }
            return result;
        }
        try {
            debugTarget.terminate();
        }
        catch (DebugException debugException) {}
        return null;
    }
}

