/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;

public final class PHPPairMatcher
implements ICharacterPairMatcher {
    private char[] fPairs;
    private IDocument fDocument;
    private int fOffset;
    private int fStartPos;
    private int fEndPos;
    private int fAnchor;
    private boolean fHighlightAngularBrackets = false;

    public PHPPairMatcher(char[] pairs) {
        this.fPairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.fOffset = offset;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchPairsAt() {
        int pairIndex1 = this.fPairs.length;
        int pairIndex2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char prevChar = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int i = 0;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fStartPos = this.fOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fEndPos = this.fOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[pairIndex2 - 1], this.fPairs[pairIndex2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
                return false;
            }
            if (this.fStartPos <= -1) return false;
            this.fAnchor = 1;
            this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[pairIndex1], this.fPairs[pairIndex1 + 1], this.fDocument);
            if (this.fEndPos > -1) {
                return true;
            }
            this.fStartPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int searchForClosingPeer(int offset, char openingPeer, char closingPeer, IDocument document) throws BadLocationException {
        boolean useGenericsHeuristic;
        boolean bl = useGenericsHeuristic = openingPeer == '<';
        if (useGenericsHeuristic && !this.fHighlightAngularBrackets) {
            return -1;
        }
        PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, (int)offset, (boolean)false);
        if (useGenericsHeuristic && !this.isTypeParameterBracket(offset, document, scanner)) {
            return -1;
        }
        return scanner.findClosingPeer(offset + 1, openingPeer, closingPeer);
    }

    private int searchForOpeningPeer(int offset, char openingPeer, char closingPeer, IDocument document) throws BadLocationException {
        boolean useGenericsHeuristic;
        boolean bl = useGenericsHeuristic = openingPeer == '<';
        if (useGenericsHeuristic && !this.fHighlightAngularBrackets) {
            return -1;
        }
        PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)document, (int)offset, (boolean)false);
        int peer = scanner.findOpeningPeer(offset - 1, openingPeer, closingPeer);
        if (peer == -1) {
            return -1;
        }
        if (useGenericsHeuristic && !this.isTypeParameterBracket(peer, document, scanner)) {
            return -1;
        }
        return peer;
    }

    private boolean isTypeParameterBracket(int offset, IDocument document, PHPHeuristicScanner scanner) {
        try {
            String previous;
            IRegion line = document.getLineInformationOfOffset(offset);
            int prevToken = scanner.previousToken(offset - 1, line.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String string = previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            return prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isTypeParameterIntroducer(previous) || prevToken == -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTypeParameterIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }
}

