/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;

public class AbstractSemanticApplyWithNS
extends AbstractSemanticApply {
    private ISourceModule sourceModule = null;
    protected NamespaceDeclaration fCurrentNamespace;
    protected Map<String, UseStatementPart> fLastUseParts = new HashMap<String, UseStatementPart>();

    public AbstractSemanticApplyWithNS(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
    }

    protected IDLTKSearchScope createSearchScope() {
        IScriptProject scriptProject = this.sourceModule.getScriptProject();
        if (scriptProject != null) {
            return SearchEngine.createSearchScope((IModelElement)scriptProject);
        }
        IProjectFragment projectFragment = (IProjectFragment)this.sourceModule.getAncestor(3);
        if (projectFragment != null) {
            return SearchEngine.createSearchScope((IModelElement)projectFragment);
        }
        return SearchEngine.createSearchScope((IModelElement)this.sourceModule);
    }

    public boolean visit(UseStatement useStatement) {
        List useParts = useStatement.parts();
        for (UseStatementPart part : useParts) {
            String name = null;
            if (part.getAlias() != null) {
                name = part.getAlias().getName();
            } else {
                name = part.getName().getName();
                int index = name.lastIndexOf(92);
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
            }
            this.fLastUseParts.put(name, part);
        }
        return true;
    }

    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        this.fCurrentNamespace = namespaceDeclaration;
        this.fLastUseParts.clear();
        return true;
    }

    public void endVisit(NamespaceDeclaration namespaceDeclaration) {
        this.fCurrentNamespace = null;
        this.fLastUseParts.clear();
    }
}

