/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import com.ibm.icu.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.ptp.core.attributes.AbstractAttributeDefinition;
import org.eclipse.ptp.core.attributes.DateAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateAttributeDefinition
extends AbstractAttributeDefinition<Calendar, DateAttribute, DateAttributeDefinition> {
    private Date minDate = new Date(Long.MIN_VALUE);
    private Date maxDate = new Date(Long.MAX_VALUE);
    private final DateFormat outputDateFormat;
    private final Date defaultValue;

    public DateAttributeDefinition(String uniqueId, String name, String description, boolean display, Date defaultValue, DateFormat outputDateFormat) {
        super(uniqueId, name, description, display);
        this.defaultValue = defaultValue;
        this.outputDateFormat = outputDateFormat;
    }

    public DateAttributeDefinition(String uniqueId, String name, String description, boolean display, Date defaultValue, DateFormat outputDateFormat, Date min, Date max) throws IllegalValueException {
        super(uniqueId, name, description, display);
        if (defaultValue.compareTo(this.getMinDate()) < 0) {
            throw new IllegalValueException(Messages.DateAttributeDefinition_0);
        }
        if (defaultValue.compareTo(this.getMaxDate()) > 0) {
            throw new IllegalValueException(Messages.DateAttributeDefinition_1);
        }
        this.defaultValue = defaultValue;
        this.outputDateFormat = outputDateFormat;
    }

    @Override
    public DateAttribute create() throws IllegalValueException {
        return new DateAttribute(this, this.defaultValue);
    }

    @Override
    public DateAttribute create(String value) throws IllegalValueException {
        return new DateAttribute(this, value);
    }

    public DateFormat getDateFormat() {
        return this.outputDateFormat;
    }

    public synchronized Date getMaxDate() {
        return this.maxDate;
    }

    public synchronized Date getMinDate() {
        return this.minDate;
    }

    public synchronized void setValidRange(Date minDate, Date maxDate) throws IllegalValueException {
        this.minDate = minDate == null ? new Date(Long.MIN_VALUE) : minDate;
        this.maxDate = maxDate == null ? new Date(Long.MAX_VALUE) : maxDate;
        if (this.minDate.compareTo(this.maxDate) > 0) {
            throw new IllegalArgumentException(Messages.DateAttributeDefinition_2);
        }
    }
}

