/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttributeDefinition;
import org.eclipse.ptp.core.attributes.DoubleAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleAttributeDefinition
extends AbstractAttributeDefinition<Double, DoubleAttribute, DoubleAttributeDefinition> {
    private final Double minValue;
    private final Double maxValue;
    private final Double defaultValue;

    public DoubleAttributeDefinition(String uniqueId, String name, String description, boolean display, Double defaultValue) {
        super(uniqueId, name, description, display);
        this.defaultValue = defaultValue;
        this.minValue = Double.NEGATIVE_INFINITY;
        this.maxValue = Double.POSITIVE_INFINITY;
    }

    public DoubleAttributeDefinition(String uniqueId, String name, String description, boolean display, Double defaultValue, double minValue, double maxValue) throws IllegalValueException {
        super(uniqueId, name, description, display);
        if (minValue > maxValue) {
            throw new IllegalArgumentException(Messages.DoubleAttributeDefinition_0);
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalValueException(Messages.DoubleAttributeDefinition_1);
        }
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public DoubleAttribute create() throws IllegalValueException {
        return new DoubleAttribute(this, this.defaultValue);
    }

    @Override
    public DoubleAttribute create(String value) throws IllegalValueException {
        return new DoubleAttribute(this, value);
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }
}

