/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttributeDefinition;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerAttribute
extends AbstractAttribute<Integer, IntegerAttribute, IntegerAttributeDefinition> {
    private Integer value;

    public IntegerAttribute(IntegerAttributeDefinition definition, Integer initialValue) throws IllegalValueException {
        super(definition);
        this.setValue(initialValue);
    }

    public IntegerAttribute(IntegerAttributeDefinition definition, String initialValue) throws IllegalValueException {
        super(definition);
        this.setValueAsString(initialValue);
    }

    @Override
    protected synchronized int doCompareTo(IntegerAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    protected IntegerAttribute doCopy() {
        try {
            return new IntegerAttribute((IntegerAttributeDefinition)this.getDefinition(), this.value);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected synchronized boolean doEquals(IntegerAttribute other) {
        return this.value.equals(other.value);
    }

    @Override
    protected synchronized int doHashCode() {
        return this.value.hashCode();
    }

    private int getMaxValue() {
        return ((IntegerAttributeDefinition)this.getDefinition()).getMaxValue();
    }

    private int getMinValue() {
        return ((IntegerAttributeDefinition)this.getDefinition()).getMinValue();
    }

    @Override
    public synchronized Integer getValue() {
        return (int)this.value;
    }

    @Override
    public synchronized String getValueAsString() {
        return this.value.toString();
    }

    @Override
    public boolean isValid(String string) {
        try {
            int val = Integer.parseInt(string);
            return val >= this.getMinValue() && val <= this.getMaxValue();
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public synchronized void setValue(Integer value) throws IllegalValueException {
        if (value < this.getMinValue() || value > this.getMaxValue()) {
            throw new IllegalValueException(Messages.IntegerAttribute_0);
        }
        this.value = value;
    }

    @Override
    public synchronized void setValueAsString(String string) throws IllegalValueException {
        try {
            Integer value = Integer.valueOf(string);
            if (value < this.getMinValue() || value > this.getMaxValue()) {
                throw new IllegalValueException(Messages.IntegerAttribute_1);
            }
            this.value = value;
        }
        catch (NumberFormatException e) {
            throw new IllegalValueException(e);
        }
    }
}

