/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.internal.core.elements.Parent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PUniverse
extends Parent
implements IPUniverse {
    private static final int RMID_SHIFT = 24;
    private int nextResourceManagerId = 1;
    private final List<IPResourceManager> resourceManagers = Collections.synchronizedList(new LinkedList());
    protected String NAME_TAG = "universe ";

    private static IAttribute<?, ?, ?>[] getDefaultAttributes(String name) {
        StringAttribute nameAttr = ElementAttributes.getNameAttributeDefinition().create(name);
        return new IAttribute[]{nameAttr};
    }

    public PUniverse() {
        super("1", null, PUniverse.getDefaultAttributes("TheUniverse"));
    }

    @Override
    public void addResourceManager(IPResourceManager addedManager) {
        this.resourceManagers.add(addedManager);
    }

    @Override
    public void addResourceManagers(IPResourceManager[] addedManagers) {
        IPResourceManager[] iPResourceManagerArray = addedManagers;
        int n = addedManagers.length;
        int n2 = 0;
        while (n2 < n) {
            IPResourceManager rm = iPResourceManagerArray[n2];
            this.addResourceManager(rm);
            ++n2;
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
    }

    @Override
    public synchronized String getNextResourceManagerId() {
        return Integer.toString(this.nextResourceManagerId++ << 24);
    }

    @Override
    public IPResourceManager[] getResourceManagers() {
        return this.resourceManagers.toArray(new IPResourceManager[0]);
    }

    @Override
    public void removeResourceManager(IPResourceManager removedManager) {
        this.resourceManagers.remove(removedManager);
    }
}

