/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.listeners.IJobListener;
import org.eclipse.ptp.internal.core.events.JobChangedEvent;
import org.eclipse.ptp.rmsystem.AbstractResourceManager;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerMonitor;

public abstract class AbstractResourceManagerMonitor
implements IResourceManagerMonitor {
    private final ListenerList fJobListeners = new ListenerList();
    private final ModelManager fModelManager = (ModelManager)PTPCorePlugin.getDefault().getModelManager();
    private final AbstractResourceManagerConfiguration fConfig;
    private IResourceManager fResourceManager = null;

    public AbstractResourceManagerMonitor(AbstractResourceManagerConfiguration config) {
        this.fConfig = config;
    }

    public void addJob(String jobId, IJobStatus status) {
        this.doAddJob(jobId, status);
    }

    public void addJobListener(IJobListener listener) {
        this.fJobListeners.add((Object)listener);
    }

    public void dispose() {
        this.doDispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter == IPResourceManager.class) {
            return this.getPResourceManager();
        }
        return null;
    }

    public IResourceManagerComponentConfiguration getMonitorConfiguration() {
        return this.fConfig;
    }

    public void removeJob(String jobId) {
        this.doRemoveJob(jobId);
    }

    public void removeJobListener(IJobListener listener) {
        this.fJobListeners.remove((Object)listener);
    }

    public void start(IProgressMonitor monitor) throws CoreException {
        this.doStartup(monitor);
    }

    public void stop() throws CoreException {
        this.doShutdown();
    }

    public void updateJob(String jobId, IJobStatus status) {
        this.doUpdateJob(jobId, status);
    }

    protected abstract void doAddJob(String var1, IJobStatus var2);

    protected abstract void doDispose();

    protected abstract void doRemoveJob(String var1);

    protected abstract void doShutdown() throws CoreException;

    protected abstract void doStartup(IProgressMonitor var1) throws CoreException;

    protected abstract void doUpdateJob(String var1, IJobStatus var2);

    protected void fireJobChanged(String jobId) {
        JobChangedEvent e = new JobChangedEvent(this.getResourceManager(), jobId);
        Object[] objectArray = this.fJobListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireResourceManagerError(String message) {
        this.getResourceManager().fireResourceManagerError(message);
    }

    protected ModelManager getModelManager() {
        return this.fModelManager;
    }

    protected IPResourceManager getPResourceManager() {
        return (IPResourceManager)this.getResourceManager().getAdapter(IPResourceManager.class);
    }

    protected AbstractResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(this.fConfig.getUniqueName());
        }
        return (AbstractResourceManager)this.fResourceManager;
    }
}

