/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerMonitor;
import org.eclipse.ptp.rmsystem.IJobStatus;
import org.eclipse.ptp.rtsystem.AbstractRuntimeResourceManager;
import org.eclipse.ptp.rtsystem.IRuntimeEventListener;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeAttributeDefinitionEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeConnectedStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeErrorStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMessageEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNewQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeQueueChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRMChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveAllEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveJobEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveMachineEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveNodeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveProcessEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRemoveQueueEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeRunningStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeShutdownStateEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeStartupErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeTerminateJobErrorEvent;
import org.eclipse.ptp.utils.core.BitSetIterable;
import org.eclipse.ptp.utils.core.RangeSet;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntimeResourceManagerMonitor
extends AbstractResourceManagerMonitor
implements IRuntimeEventListener {
    private final Map<String, IStreamsProxy> fStreamProxies = new HashMap<String, IStreamsProxy>();

    public AbstractRuntimeResourceManagerMonitor(AbstractResourceManagerConfiguration config) {
        super(config);
    }

    @Override
    public void doAddJob(String jobId, IJobStatus status) {
    }

    @Override
    public void doRemoveJob(String jobId) {
    }

    @Override
    public void doUpdateJob(String jobId, IJobStatus status) {
    }

    @Override
    public void handleEvent(IRuntimeAttributeDefinitionEvent e) {
        IAttributeDefinition<?, ?, ?>[] iAttributeDefinitionArray = e.getDefinitions();
        int n = iAttributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDefinition<?, ?, ?> attr = iAttributeDefinitionArray[n2];
            this.getRuntimeSystem().getAttributeDefinitionManager().setAttributeDefinition(attr);
            ++n2;
        }
    }

    @Override
    public void handleEvent(IRuntimeConnectedStateEvent e) {
    }

    @Override
    public void handleEvent(IRuntimeErrorStateEvent e) {
        this.getResourceManager().fireResourceManagerError(Messages.AbstractRuntimeResourceManager_6);
    }

    @Override
    public void handleEvent(IRuntimeJobChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPJob> changedJobs = new ArrayList<IPJob>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet jobIds = mgrEntry.getKey();
            for (String jobId : jobIds) {
                IPJob job = this.getPResourceManager().getJobById(jobId);
                if (job != null) {
                    changedJobs.add(job);
                    continue;
                }
                PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_7) + jobId);
            }
            this.doUpdateJobs(changedJobs, attrs);
            changedJobs.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeMachineChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPMachine> machines = new ArrayList<IPMachine>();
        for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet machineIds = entry.getKey();
            for (String elementId : machineIds) {
                IPMachine machine = this.getPResourceManager().getMachineById(elementId);
                if (machine != null) {
                    machines.add(machine);
                    continue;
                }
                System.out.println(String.valueOf(Messages.AbstractRuntimeResourceManager_8) + elementId);
            }
            this.doUpdateMachines(machines, attrs);
            machines.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeMessageEvent e) {
        int severity = 4;
        switch (e.getLevel()) {
            case INFO: 
            case DEBUG: {
                severity = 1;
                break;
            }
            case FATAL: 
            case ERROR: 
            case UNDEFINED: {
                severity = 4;
                break;
            }
            case WARNING: {
                severity = 2;
            }
        }
        StatusManager.getManager().handle((IStatus)new Status(severity, "org.eclipse.ptp.core", e.getText()), severity == 4 ? 2 : 1);
    }

    @Override
    public void handleEvent(IRuntimeNewJobEvent e) {
        IPQueue queue = this.getPResourceManager().getQueueById(e.getParentId());
        ElementAttributeManager mgr = e.getElementAttributeManager();
        ArrayList<IPJob> newJobs = new ArrayList<IPJob>();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager jobAttrs = entry.getValue();
            RangeSet jobIds = entry.getKey();
            for (String elementId : jobIds) {
                IPJob job = this.getPResourceManager().getJobById(elementId);
                if (job != null) continue;
                job = this.doCreateJob(elementId, jobAttrs);
                newJobs.add(job);
                this.fStreamProxies.put(elementId, new StreamsProxy(job));
            }
        }
        if (newJobs.size() > 0) {
            this.getPResourceManager().addJobs(queue, newJobs);
        }
    }

    @Override
    public void handleEvent(IRuntimeNewMachineEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet machineIds = entry.getKey();
            ArrayList<IPMachine> newMachines = new ArrayList<IPMachine>(machineIds.size());
            for (String elementId : machineIds) {
                IPMachine machine = this.getPResourceManager().getMachineById(elementId);
                if (machine != null) continue;
                machine = this.doCreateMachine(elementId, attrs);
                newMachines.add(machine);
            }
            if (newMachines.size() <= 0) continue;
            this.getPResourceManager().addMachines(newMachines);
        }
    }

    @Override
    public void handleEvent(IRuntimeNewNodeEvent e) {
        IPMachine machine = this.getPResourceManager().getMachineById(e.getParentId());
        if (machine != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            ArrayList<IPNode> newNodes = new ArrayList<IPNode>();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager attrs = entry.getValue();
                RangeSet nodeIds = entry.getKey();
                for (String elementId : nodeIds) {
                    IPNode node = this.getPResourceManager().getNodeById(elementId);
                    if (node != null) continue;
                    node = this.doCreateNode(machine, elementId, attrs);
                    newNodes.add(node);
                }
            }
            if (newNodes.size() > 0) {
                this.getPResourceManager().addNodes(machine, newNodes);
            }
        } else {
            PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_1) + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewProcessEvent e) {
        String jobId = e.getParentId();
        IPJob job = this.getPResourceManager().getJobById(jobId);
        if (job != null) {
            ElementAttributeManager mgr = e.getElementAttributeManager();
            for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
                AttributeManager attrs = entry.getValue();
                RangeSet processJobRanks = entry.getKey();
                BitSet newProcessJobRanks = this.getProcessJobRanks(processJobRanks);
                this.getPResourceManager().addProcessesByJobRanks(job, newProcessJobRanks, attrs);
            }
        } else {
            PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_2) + e.getParentId());
        }
    }

    @Override
    public void handleEvent(IRuntimeNewQueueEvent e) {
        ElementAttributeManager mgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> entry : mgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet queueIds = entry.getKey();
            ArrayList<IPQueue> newQueues = new ArrayList<IPQueue>(queueIds.size());
            for (String elementId : queueIds) {
                IPQueue queue = this.getPResourceManager().getQueueById(elementId);
                if (queue != null) continue;
                queue = this.doCreateQueue(elementId, attrs);
                newQueues.add(queue);
            }
            if (newQueues.size() <= 0) continue;
            this.getPResourceManager().addQueues(newQueues);
        }
    }

    @Override
    public void handleEvent(IRuntimeNodeChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        HashMap<IPMachine, ArrayList<IPNode>> map = new HashMap<IPMachine, ArrayList<IPNode>>();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet nodeIds = mgrEntry.getKey();
            for (String elementId : nodeIds) {
                IPNode node = this.getPResourceManager().getNodeById(elementId);
                if (node != null) {
                    IPMachine machine = node.getMachine();
                    ArrayList<IPNode> changedNodes = (ArrayList<IPNode>)map.get(machine);
                    if (changedNodes == null) {
                        changedNodes = new ArrayList<IPNode>();
                        map.put(machine, changedNodes);
                    }
                    changedNodes.add(node);
                    continue;
                }
                PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_9) + elementId);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.doUpdateNodes((IPMachine)entry.getKey(), (Collection)entry.getValue(), attrs);
            }
            map.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeProcessChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        String jobId = e.getJobId();
        IPJob job = this.getPResourceManager().getJobById(jobId);
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet processJobRanks = mgrEntry.getKey();
            BitSet changedProcessesJobRanks = this.getProcessJobRanks(processJobRanks);
            this.updateProcessesByJobRanks(job, changedProcessesJobRanks, attrs);
        }
    }

    @Override
    public void handleEvent(IRuntimeQueueChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        ArrayList<IPQueue> queues = new ArrayList<IPQueue>();
        for (Map.Entry<RangeSet, AttributeManager> entry : eMgr.getEntrySet()) {
            AttributeManager attrs = entry.getValue();
            RangeSet queueIds = entry.getKey();
            for (String elementId : queueIds) {
                IPQueue queue = this.getPResourceManager().getQueueById(elementId);
                if (queue != null) {
                    queues.add(queue);
                    continue;
                }
                PTPCorePlugin.log(String.valueOf(Messages.AbstractRuntimeResourceManager_3) + elementId);
            }
            this.doUpdateQueues(queues, attrs);
            queues.clear();
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveAllEvent e) {
        this.removeAll();
    }

    @Override
    public void handleEvent(IRuntimeRemoveJobEvent e) {
        HashSet<IPJob> removedJobs = new HashSet<IPJob>();
        for (String elementId : e.getElementIds()) {
            IPJob job = this.getPResourceManager().getJobById(elementId);
            if (job == null) continue;
            removedJobs.add(job);
        }
        this.getPResourceManager().removeJobs(removedJobs);
    }

    @Override
    public void handleEvent(IRuntimeRemoveMachineEvent e) {
        ArrayList<IPMachine> machines = new ArrayList<IPMachine>();
        for (String elementId : e.getElementIds()) {
            IPMachine machine = this.getPResourceManager().getMachineById(elementId);
            if (machine == null) continue;
            machines.add(machine);
        }
        this.getPResourceManager().removeMachines(machines);
    }

    @Override
    public void handleEvent(IRuntimeRemoveNodeEvent e) {
        HashMap<IPMachine, ArrayList<IPNode>> map = new HashMap<IPMachine, ArrayList<IPNode>>();
        for (String elementId : e.getElementIds()) {
            IPNode node = this.getPResourceManager().getNodeById(elementId);
            if (node == null) continue;
            IPMachine machine = node.getMachine();
            ArrayList<IPNode> nodes = (ArrayList<IPNode>)map.get(machine);
            if (nodes == null) {
                nodes = new ArrayList<IPNode>();
                map.put(machine, nodes);
            }
            nodes.add(node);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.getPResourceManager().removeNodes((IPMachine)entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void handleEvent(IRuntimeRemoveProcessEvent e) {
        RangeSet jobRanks = e.getProcessJobRanks();
        BitSet removedProcessJobRanks = this.getProcessJobRanks(jobRanks);
        IPJob job = this.getPResourceManager().getJobById(e.getJobId());
        job.removeProcessesByJobRanks(removedProcessJobRanks);
    }

    @Override
    public void handleEvent(IRuntimeRemoveQueueEvent e) {
        ArrayList<IPQueue> queues = new ArrayList<IPQueue>();
        for (String elementId : e.getElementIds()) {
            IPQueue queue = this.getPResourceManager().getQueueById(elementId);
            if (queue == null) continue;
            queues.add(queue);
        }
        this.getPResourceManager().removeQueues(queues);
    }

    @Override
    public void handleEvent(IRuntimeRMChangeEvent e) {
        ElementAttributeManager eMgr = e.getElementAttributeManager();
        for (Map.Entry<RangeSet, AttributeManager> mgrEntry : eMgr.getEntrySet()) {
            AttributeManager attrs = mgrEntry.getValue();
            RangeSet rmIds = mgrEntry.getKey();
            for (String elementId : rmIds) {
                if (!this.getPResourceManager().getID().equals(elementId)) continue;
                this.getPResourceManager().addAttributes(attrs.getAttributes());
                this.getResourceManager().fireResourceManagerChanged();
            }
        }
    }

    @Override
    public void handleEvent(IRuntimeRunningStateEvent e) {
        try {
            this.getRuntimeSystem().startEvents();
        }
        catch (CoreException ex) {
            this.getResourceManager().fireResourceManagerError(ex.getMessage());
        }
        this.getResourceManager().fireResourceManagerStarted();
    }

    @Override
    public void handleEvent(IRuntimeShutdownStateEvent e) {
        this.getResourceManager().fireResourceManagerStopped();
    }

    @Override
    public void handleEvent(IRuntimeStartupErrorEvent e) {
        this.getResourceManager().fireResourceManagerError(e.getErrorMessage());
    }

    @Override
    public void handleEvent(IRuntimeSubmitJobErrorEvent e) {
    }

    @Override
    public void handleEvent(IRuntimeTerminateJobErrorEvent e) {
    }

    private void removeAll() {
        this.getPResourceManager().removeJobs(Arrays.asList(this.getPResourceManager().getJobs()));
        this.getPResourceManager().removeQueues(Arrays.asList(this.getPResourceManager().getQueues()));
        this.getPResourceManager().removeMachines(Arrays.asList(this.getPResourceManager().getMachines()));
    }

    private boolean updateProcessesByJobRanks(IPJob job, BitSet processJobRanks, AttributeManager attrs) {
        StringAttributeDefinition nodeIdAttributeDefinition = ProcessAttributes.getNodeIdAttributeDefinition();
        StringAttribute newNodeId = (StringAttribute)attrs.getAttribute(nodeIdAttributeDefinition);
        if (newNodeId != null) {
            IPNode newNode = this.getPResourceManager().getNodeById(newNodeId.getValue());
            newNode.addJobProcessRanks(job, processJobRanks);
            Set oldNodeIds = job.getProcessAttributes(nodeIdAttributeDefinition, processJobRanks);
            oldNodeIds.remove(newNodeId);
            for (StringAttribute oldNodeId : oldNodeIds) {
                IPNode oldNode = this.getPResourceManager().getNodeById(oldNodeId.getValue());
                if (oldNode == null) continue;
                oldNode.removeJobProcessRanks(job, processJobRanks);
            }
        }
        job.addProcessAttributes(processJobRanks, attrs);
        return true;
    }

    protected IPJob doCreateJob(String jobId, AttributeManager attrs) {
        return this.getPResourceManager().newJob(jobId, attrs);
    }

    protected IPMachine doCreateMachine(String machineId, AttributeManager attrs) {
        return this.getPResourceManager().newMachine(machineId, attrs);
    }

    protected IPNode doCreateNode(IPMachine machine, String nodeId, AttributeManager attrs) {
        return this.getPResourceManager().newNode(machine, nodeId, attrs);
    }

    protected IPQueue doCreateQueue(String queueId, AttributeManager attrs) {
        return this.getPResourceManager().newQueue(queueId, attrs);
    }

    @Override
    protected void doDispose() {
    }

    @Override
    protected void doShutdown() throws CoreException {
        this.getRuntimeSystem().removeRuntimeEventListener(this);
        this.removeAll();
    }

    @Override
    protected void doStartup(IProgressMonitor monitor) throws CoreException {
        this.getRuntimeSystem().addRuntimeEventListener(this);
    }

    protected void doUpdateJobs(Collection<IPJob> jobs, AttributeManager attrs) {
        this.getPResourceManager().addJobAttributes(jobs, attrs.getAttributes());
        for (IPJob job : jobs) {
            this.getResourceManager().fireJobChanged(job.getID());
        }
    }

    protected void doUpdateMachines(Collection<IPMachine> machines, AttributeManager attrs) {
        this.getPResourceManager().addMachineAttributes(machines, attrs.getAttributes());
    }

    protected void doUpdateNodes(IPMachine machine, Collection<IPNode> nodes, AttributeManager attrs) {
        machine.addNodeAttributes(nodes, attrs.getAttributes());
    }

    protected void doUpdateQueues(Collection<IPQueue> queues, AttributeManager attrs) {
        this.getPResourceManager().addQueueAttributes(queues, attrs.getAttributes());
    }

    protected Integer getProcessJobRank(String sJobRank) {
        Integer procId;
        try {
            procId = Integer.valueOf(sJobRank);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return procId;
    }

    protected BitSet getProcessJobRanks(RangeSet processJobRanks) {
        BitSet bitSet = new BitSet(processJobRanks.size());
        for (String sRank : processJobRanks) {
            Integer rank = this.getProcessJobRank(sRank);
            if (rank != null) {
                bitSet.set(rank);
                continue;
            }
            PTPCorePlugin.log(NLS.bind((String)Messages.AbstractRuntimeResourceManager_12, (Object)sRank));
        }
        return bitSet;
    }

    protected IStreamsProxy getProxy(String jobId) {
        return this.fStreamProxies.get(jobId);
    }

    @Override
    protected AbstractRuntimeResourceManager getResourceManager() {
        return (AbstractRuntimeResourceManager)super.getResourceManager();
    }

    protected IRuntimeSystem getRuntimeSystem() {
        return this.getResourceManager().getRuntimeSystem();
    }

    private class StreamMonitor
    implements IStreamMonitor,
    IJobChildListener {
        private final ListenerList fListeners = new ListenerList();
        private final StringBuffer fContents = new StringBuffer();
        private final IPJob fJob;
        private final StringAttributeDefinition fAttrDef;
        private final boolean fPrefix;

        public StreamMonitor(IPJob job, StringAttributeDefinition attrDef, boolean prefix) {
            this.fJob = job;
            this.fAttrDef = attrDef;
            this.fPrefix = prefix;
            job.addChildListener(this);
        }

        public synchronized void addListener(IStreamListener listener) {
            this.fListeners.add((Object)listener);
        }

        public synchronized String getContents() {
            return this.fContents.toString();
        }

        public void handleEvent(IChangedProcessEvent e) {
            boolean hasOutput;
            boolean bl = hasOutput = e.getAttributes().getAttribute(this.fAttrDef) != null;
            if (hasOutput) {
                BitSet indices = e.getProcesses();
                for (Integer index : new BitSetIterable(indices)) {
                    StringAttribute stdout = (StringAttribute)this.fJob.getProcessAttribute(this.fAttrDef, (int)index);
                    if (stdout == null) continue;
                    String text = "";
                    if (this.fPrefix) {
                        text = "[" + index + "] ";
                    }
                    text = String.valueOf(text) + stdout.getValueAsString() + "\n";
                    this.fContents.append(text);
                    this.fireStreamAppended(text);
                }
            }
        }

        public void handleEvent(INewProcessEvent e) {
        }

        public void handleEvent(IRemoveProcessEvent e) {
        }

        public synchronized void removeListener(IStreamListener listener) {
            this.fListeners.remove((Object)listener);
        }

        private void fireStreamAppended(String text) {
            Object[] objectArray = this.fListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IStreamListener)listener).streamAppended(text, (IStreamMonitor)this);
                ++n2;
            }
        }
    }

    private class StreamsProxy
    implements IStreamsProxy {
        private final IStreamMonitor fErrorStreamMonitor;
        private final IStreamMonitor fOutputStreamMonitor;
        private final boolean fPrefix = false;

        public StreamsProxy(IPJob job) {
            this.fErrorStreamMonitor = new StreamMonitor(job, ProcessAttributes.getStderrAttributeDefinition(), false);
            this.fOutputStreamMonitor = new StreamMonitor(job, ProcessAttributes.getStdoutAttributeDefinition(), false);
        }

        public IStreamMonitor getErrorStreamMonitor() {
            return this.fErrorStreamMonitor;
        }

        public IStreamMonitor getOutputStreamMonitor() {
            return this.fOutputStreamMonitor;
        }

        public void write(String input) throws IOException {
        }
    }
}

