/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeRange;
import org.eclipse.ptp.debug.internal.core.pdi.aif.TypeDerived;

public class AIFTypeArray
extends TypeDerived
implements IAIFTypeArray {
    private IAIFTypeRange fRange;

    public IAIFTypeRange getRange() {
        return this.fRange;
    }

    public int sizeof() {
        return this.getRange().getSize() * super.sizeof();
    }

    public String toString() {
        return String.valueOf(String.valueOf('[')) + this.getRange().toString() + ']' + this.getBaseType().toString();
    }

    public String parse(String fmt) throws AIFFormatException {
        if ((fmt = AIFFactory.parseType(fmt)).charAt(0) != ']') {
            throw new AIFFormatException(Messages.AIFTypeArray_1);
        }
        IAIFType type = AIFFactory.getType();
        if (!(type instanceof IAIFTypeRange)) {
            throw new AIFFormatException(Messages.AIFTypeArray_0);
        }
        this.fRange = (IAIFTypeRange)type;
        return super.parse(fmt.substring(1));
    }
}

