/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeFloat;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFType;

public class AIFTypeFloat
extends AIFType
implements IAIFTypeFloat {
    private int fSize;
    private final boolean fComplex = false;
    private final boolean fImaginary = false;
    private final boolean fIsLong = false;

    public boolean isComplex() {
        return false;
    }

    public boolean isImaginary() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public String parse(String fmt) throws AIFFormatException {
        int pos = AIFFactory.getFirstNonDigitPos(fmt, 0, false);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeFloat_0);
        }
        this.fSize = Integer.parseInt(fmt.substring(0, pos));
        return fmt.substring(pos);
    }

    public int sizeof() {
        return this.fSize;
    }

    public String toString() {
        return "f" + this.sizeof();
    }
}

