/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import org.eclipse.ptp.debug.core.pdi.IPDICondition;

public class Condition
implements IPDICondition {
    private int ignoreCount;
    private String expression;
    private String[] tids;

    public Condition(int ignore, String exp, String[] ids) {
        this.ignoreCount = ignore;
        this.expression = exp == null ? new String() : exp;
        this.tids = ids == null ? new String[]{} : ids;
    }

    public boolean equals(IPDICondition obj) {
        if (obj instanceof Condition) {
            Condition cond = (Condition)obj;
            if (cond.getIgnoreCount() != this.getIgnoreCount()) {
                return false;
            }
            if (cond.getExpression().compareTo(this.getExpression()) != 0) {
                return false;
            }
            if (cond.getThreadIds().length != this.getThreadIds().length) {
                return false;
            }
            int i = 0;
            while (i < cond.getThreadIds().length) {
                if (cond.getThreadIds()[i].compareTo(this.getThreadIds()[i]) != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public String[] getThreadIds() {
        return this.tids;
    }
}

