/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.ptp.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.ptp.debug.internal.core.sourcelookup.PSourceNotFoundElement;

public class PSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private static final NoSourceElement gfNoSource = new NoSourceElement();
    private final ListenerList fListeners = new ListenerList(1);

    public void addSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void dispose() {
        this.fListeners.clear();
        super.dispose();
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] foundElements;
        String name = null;
        if (object instanceof IAdaptable) {
            IPStackFrame frame = (IPStackFrame)((IAdaptable)object).getAdapter(IPStackFrame.class);
            if (frame != null && ((name = frame.getFile().trim()) == null || name.length() == 0)) {
                return new Object[]{gfNoSource};
            }
        } else if (object instanceof String) {
            name = (String)object;
        }
        if ((foundElements = super.findSourceElements(object)).length == 0 && object instanceof IDebugElement) {
            foundElements = new File(name).exists() ? new AbsolutePathSourceContainer().findSourceElements(name) : new Object[]{new PSourceNotFoundElement((IDebugElement)object)};
        }
        return foundElements;
    }

    public String getSourceName(Object object) throws CoreException {
        IPStackFrame frame;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IAdaptable && (frame = (IPStackFrame)((IAdaptable)object).getAdapter(IPStackFrame.class)) != null) {
            String name = frame.getFile();
            return name != null && name.trim().length() > 0 ? name : null;
        }
        return null;
    }

    public void removeSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISourceLookupChangeListener)listeners[i]).sourceContainersChanged(director);
            ++i;
        }
        super.sourceContainersChanged(director);
    }

    private static class NoSourceElement {
        private NoSourceElement() {
        }
    }
}

