/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.sourcelookup;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.internal.core.sourcelookup.ResourceMappingSourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceMappingSourceContainerType
extends AbstractSourceContainerTypeDelegate {
    private static final String ELEMENT_NAME = "mapEntry";
    private static final String MAPPING_PATH = "mappingPath";
    private static final String PROJECT_NAME = "project";
    private static final String PROJECT_PATH = "projectPath";

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if (ELEMENT_NAME.equals(element.getNodeName())) {
                String path = element.getAttribute(MAPPING_PATH);
                Path remote = new Path(path);
                if (!remote.isValidPath(path)) {
                    this.abort(Messages.ResourceMappingSourceContainerType_0, null);
                }
                String projectName = element.getAttribute(PROJECT_NAME);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null) {
                    Path local = new Path(element.getAttribute(PROJECT_PATH));
                    IProject container = project;
                    if (!local.isEmpty() && !(container = project.getFolder((IPath)local)).exists()) {
                        this.abort(Messages.ResourceMappingSourceContainerType_2, null);
                    }
                    return new ResourceMappingSourceContainer((IPath)remote, (IContainer)container);
                }
                this.abort(NLS.bind((String)Messages.ResourceMappingSourceContainerType_1, (Object)projectName), null);
            }
            this.abort(Messages.ResourceMappingSourceContainerType_3, null);
        }
        this.abort(Messages.ResourceMappingSourceContainerType_4, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        ResourceMappingSourceContainer entry = (ResourceMappingSourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement(ELEMENT_NAME);
        element.setAttribute(MAPPING_PATH, entry.getPath().toOSString());
        element.setAttribute(PROJECT_NAME, entry.getContainer().getProject().getName());
        IPath localPath = entry.getContainer().getProjectRelativePath();
        element.setAttribute(PROJECT_PATH, localPath.toOSString());
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

