/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.internal.ui.views.PTabItem;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ptp.ui.views.AbstractParallelView;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class PTabFolder
extends AbstractParallelView {
    protected Map<String, PTabItem> items = new HashMap<String, PTabItem>();
    protected CTabFolder folder = null;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.folder = new CTabFolder(parent, 128);
        this.folder.setBorderVisible(true);
        this.folder.setLayoutData((Object)new GridData(1808));
        this.folder.setSimple(false);
        this.folder.setUnselectedImageVisible(false);
        this.folder.setUnselectedCloseVisible(false);
        this.folder.setMinimizeVisible(true);
        this.folder.setMaximizeVisible(true);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event) {
                PTabFolder.this.folder.setMinimized(true);
            }

            public void maximize(CTabFolderEvent event) {
                PTabFolder.this.folder.setMaximized(true);
                PTabFolder.this.folder.setLayoutData((Object)new GridData(4, 4, true, true));
            }

            public void restore(CTabFolderEvent event) {
                PTabFolder.this.folder.setMinimized(false);
                PTabFolder.this.folder.setMaximized(false);
                PTabFolder.this.folder.setLayoutData((Object)new GridData(4, 4, true, false));
            }
        });
        this.createToolBarMenu(this.getViewSite().getActionBars().getToolBarManager());
    }

    public void createToolBarMenu(IToolBarManager toolBarMgr) {
        toolBarMgr.add((IContributionItem)new Separator("variablegroup"));
        toolBarMgr.add((IContributionItem)new Separator("emptygroup"));
        this.configureToolBar(toolBarMgr);
    }

    protected abstract void configureToolBar(IToolBarManager var1);

    public void setFocus() {
        this.folder.setFocus();
    }

    public CTabFolder getTabFolder() {
        return this.folder;
    }

    public void dispose() {
        this.closeAllTabs();
        super.dispose();
    }

    public void closeTab(String name) {
        if (this.items != null) {
            this.items.remove(name);
        }
    }

    public void closeAllTabs() {
        PTabItem[] pTabItemArray = this.getItems();
        int n = pTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PTabItem item = pTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.items.clear();
    }

    public PTabItem[] getItems() {
        return this.items.values().toArray(new PTabItem[0]);
    }

    public PTabItem getTab(String name) {
        return this.items.get(name);
    }

    public IPStackFrame getStackFrame() throws CoreException {
        Object obj;
        ISelection selection = this.getViewSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof IPStackFrame) {
            return (IPStackFrame)obj;
        }
        throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, Messages.PTabFolder_0, null));
    }

    public abstract void createTabItem(String var1, Object var2) throws DebugException;
}

