/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ptp.debug.internal.ui.views.PTabFolder;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public abstract class PTabItem
implements IRunnableContext {
    protected CTabItem tabItem = null;
    protected PageBook fPageBook = null;
    protected TextViewer fTextViewer = null;
    protected boolean displayError = false;
    protected PTabFolder view = null;

    public PTabItem(PTabFolder view) {
        this(view, "");
    }

    public PTabItem(PTabFolder view, String tabName) {
        this.view = view;
        this.tabItem = new CTabItem(view.getTabFolder(), 64);
        this.tabItem.setText(tabName);
        this.tabItem.setToolTipText(tabName);
        this.tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PTabItem.this.dispose();
            }
        });
    }

    public CTabItem getTabItem() {
        return this.tabItem;
    }

    public void setControl() {
        this.tabItem.setControl(this.createControl((Composite)this.tabItem.getParent()));
    }

    public void setTabName(String tabName) {
        this.tabItem.setText(tabName);
    }

    protected abstract void dispose();

    public Control createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.createErrorPage((Composite)this.fPageBook);
        this.createTabPage((Composite)this.fPageBook);
        return this.fPageBook;
    }

    public void createErrorPage(Composite parent) {
        if (this.fTextViewer == null) {
            this.fTextViewer = new TextViewer(parent, 64);
            this.fTextViewer.setDocument((IDocument)new Document());
            StyledText styleText = this.fTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(false);
        }
    }

    public void displayError(Exception e) {
        this.displayError = true;
        StyledText styleText = this.fTextViewer.getTextWidget();
        if (styleText != null) {
            styleText.setText(String.valueOf(Messages.PTabItem_0) + e.getMessage());
        }
        this.fPageBook.showPage(this.fTextViewer.getControl());
        this.clearContext();
    }

    protected abstract void createTabPage(Composite var1);

    protected abstract void clearContext();

    protected abstract void displayTab();

    public Point getTextSize(Composite composite, String text) {
        return new GC((Drawable)composite).textExtent(text);
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(this.fPageBook.getShell()).run(fork, cancelable, runnable);
    }
}

