/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.ppw;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.ppw.PPWController;
import org.eclipse.ptp.etfw.ppw.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class PPWDataManager
extends AbstractToolDataManager {
    boolean externalTarget = false;

    public void cleanup() {
    }

    public String getName() {
        return "process-PPW";
    }

    public void setExternalTarget(boolean external) {
        this.externalTarget = external;
    }

    public void process(String projname, ILaunchConfiguration configuration, final String directory) throws CoreException {
        try {
            final String[] args = new String[1];
            if (this.externalTarget || projname == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        if (s == null) {
                            s = PlatformUI.getWorkbench().getDisplay().getShells()[0];
                        }
                        FileDialog dl = new FileDialog(s, 4096);
                        dl.setFilterPath(directory);
                        dl.setFilterExtensions(new String[]{"*.par"});
                        dl.setText(Messages.PPWDataManager_0);
                        String file = dl.open();
                        if (file == null) {
                            return;
                        }
                        args[0] = file;
                    }
                });
            } else {
                boolean renameSuccess = false;
                File parFile = new File(String.valueOf(directory) + File.separator + "ppw_eclipse.par");
                File newFile = null;
                int i = 1;
                while (i < 64) {
                    newFile = new File(String.valueOf(directory) + File.separator + projname + "_" + i + ".par");
                    if (!newFile.exists()) {
                        renameSuccess = parFile.renameTo(newFile);
                        break;
                    }
                    ++i;
                }
                args[0] = renameSuccess ? newFile.getPath() : parFile.getPath();
            }
            new PPWController(this, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean highlightSourceLine(String filename, int line) {
        class SourceView
        implements Runnable {
            private final /* synthetic */ String val$filename;
            private final /* synthetic */ int val$line;

            SourceView(String string, int n) {
                this.val$filename = string;
                this.val$line = n;
            }

            public void run() {
                PPWDataManager.this.openSource(this.val$filename, this.val$line);
            }
        }
        SourceView sv = new SourceView(filename, line);
        Display.getDefault().syncExec((Runnable)sv);
        return true;
    }

    void openSource(String filename, int line) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IFile file = this.getFile(filename, root.members());
            if (file == null) {
                return;
            }
            FileEditorInput iEditorInput = new FileEditorInput(file);
            IWorkbenchPage p = PPWDataManager.getActivePage();
            String editorid = "org.eclipse.cdt.ui.editor.CEditor";
            IEditorPart part = null;
            if (p != null) {
                part = p.openEditor((IEditorInput)iEditorInput, editorid, true);
            }
            TextEditor textEditor = (TextEditor)part;
            int start = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).getLineOffset(line - 1);
            int end = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).getLineOffset(line);
            textEditor.setHighlightRange(start, end - start, true);
            TextEditor abstractTextEditor = textEditor;
            ISourceViewer viewer = null;
            Field[] fields = AbstractTextEditor.class.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if ("fSourceViewer".equals(fields[i].getName())) {
                    Field f = fields[i];
                    f.setAccessible(true);
                    viewer = (ISourceViewer)f.get(abstractTextEditor);
                    break;
                }
                ++i;
            }
            if (viewer != null) {
                viewer.revealRange(start, end - start);
                viewer.setSelectedRange(start, end - start);
            }
        }
        catch (Throwable throwable) {}
    }

    IFile getFile(String filename, IResource[] resources) {
        try {
            int j = 0;
            while (j < resources.length) {
                IFile f;
                if (resources[j] instanceof IFile ? (f = (IFile)resources[j]).getName().equals(filename) : (resources[j] instanceof IFolder ? (f = this.getFile(filename, ((IFolder)resources[j]).members())) != null : resources[j] instanceof IProject && (f = this.getFile(filename, ((IProject)resources[j]).members())) != null)) {
                    return f;
                }
                ++j;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public void view() {
    }
}

