/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.launch.ILaunchNotification;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPLaunchPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "org.eclipse.ptp.launch";
    public static final String EXTENSION_POINT_ID = "rmLaunchConfigurations";
    public static final String RESOURCE_BUNDLE = "org.eclipse.ptp.launch.LaunchPluginResources";
    private static PTPLaunchPlugin plugin;
    private final ListenerList listeners = new ListenerList();
    private ResourceBundle resourceBundle;
    private final Map<Class<? extends IResourceManager>, AbstractRMLaunchConfigurationFactory> rmLaunchConfigurationFactories = new HashMap<Class<? extends IResourceManager>, AbstractRMLaunchConfigurationFactory>();

    public static void errorDialog(String message, IStatus status) {
        PTPLaunchPlugin.log(status);
        Shell shell = PTPLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        PTPLaunchPlugin.log(t);
        Shell shell = PTPLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPLaunchPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPLaunchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPLaunchPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPLaunchPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (PTPLaunchPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPLaunchPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPLaunchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PTPLaunchPlugin.log((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static void logErrorMessage(String message) {
        PTPLaunchPlugin.log((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public PTPLaunchPlugin() {
        plugin = this;
    }

    public void addLaunchNotificationListener(ILaunchNotification listener) {
        this.listeners.add((Object)listener);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        String rmUniqueName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        IResourceManager rm = PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmUniqueName);
        if (rm.getState().equals("STARTED")) {
            return rm;
        }
        return null;
    }

    public AbstractRMLaunchConfigurationFactory getRMLaunchConfigurationFactory(IResourceManager rm) {
        if (rm == null) {
            return null;
        }
        return this.rmLaunchConfigurationFactories.get(rm.getClass());
    }

    public void notifyJobStateChange(IPJob job, JobAttributes.State state) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((ILaunchNotification)listener).jobStateChange(job, state);
            }
            catch (Exception e) {
                PTPLaunchPlugin.log(e);
            }
            ++n2;
        }
    }

    public void removeLaunchNotificationListener(ILaunchNotification listener) {
        this.listeners.remove((Object)listener);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.retrieveRMLaunchConfigurationFactories();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.rmLaunchConfigurationFactories.clear();
        plugin = null;
        this.resourceBundle = null;
    }

    public IPath verifyResource(String path, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = this.getResourceManager(configuration);
        if (rm == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.PTPLaunchPlugin_4));
        }
        IResourceManagerComponentConfiguration conf = rm.getControlConfiguration();
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId(), monitor);
        if (monitor.isCanceled()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.PTPLaunchPlugin_Operation_cancelled_by_user));
        }
        if (remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.PTPLaunchPlugin_0));
        }
        IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
        if (connMgr == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.PTPLaunchPlugin_1));
        }
        IRemoteConnection conn = connMgr.getConnection(conf.getConnectionName());
        if (conn == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.PTPLaunchPlugin_2));
        }
        IRemoteFileManager fileManager = remoteServices.getFileManager(conn);
        if (fileManager == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.PTPLaunchPlugin_3));
        }
        if (!fileManager.getResource(path).fetchInfo().exists()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.PTPLaunchPlugin_5, (Object[])new Object[]{path})));
        }
        return new Path(path);
    }

    private void retrieveRMLaunchConfigurationFactories() {
        this.rmLaunchConfigurationFactories.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractRMLaunchConfigurationFactory factory = (AbstractRMLaunchConfigurationFactory)ce.createExecutableExtension("class");
                    Class<? extends IResourceManager> resourceManagerClass = factory.getResourceManagerClass();
                    this.rmLaunchConfigurationFactories.put(resourceManagerClass, factory);
                }
                catch (CoreException e) {
                    PTPLaunchPlugin.log(e);
                }
                ++i;
            }
            ++iext;
        }
    }
}

