/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.launch.AbstractParallelLaunchConfigurationDelegate;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.RuntimeProcess;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerControl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class ParallelLaunchConfigurationDelegate
extends AbstractParallelLaunchConfigurationDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            if (!(launch instanceof IPLaunch)) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.ParallelLaunchConfigurationDelegate_Invalid_launch_object));
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
            progress.setTaskName(NLS.bind((String)Messages.ParallelLaunchConfigurationDelegate_3, (Object)configuration.getName()));
            progress.setWorkRemaining(90);
            if (progress.isCanceled()) {
                return;
            }
            final IResourceManager rm = this.getResourceManager(configuration);
            if (rm == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_No_ResourceManager));
            }
            if (!rm.getState().equals("STARTED")) {
                if (!Preferences.getBoolean((String)PTPLaunchPlugin.getUniqueIdentifier(), (String)"autoStart")) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.ParallelLaunchConfigurationDelegate_Confirm_start, (String)NLS.bind((String)Messages.ParallelLaunchConfigurationDelegate_RM_currently_stopped, (Object)configuration.getName()), (String)Messages.ParallelLaunchConfigurationDelegate_Always_start, (boolean)false, null, null);
                            if (dialog.getReturnCode() == 0) {
                                ParallelLaunchConfigurationDelegate.this.startRM(rm);
                            }
                            if (dialog.getToggleState()) {
                                Preferences.setBoolean((String)PTPLaunchPlugin.getUniqueIdentifier(), (String)"autoStart", (dialog.getReturnCode() == 0 ? 1 : 0) != 0);
                            }
                        }
                    });
                } else {
                    this.startRM(rm);
                }
                if (!rm.getState().equals("STARTED")) {
                    return;
                }
            }
            progress.worked(10);
            progress.subTask(Messages.ParallelLaunchConfigurationDelegate_4);
            this.verifyLaunchAttributes(configuration, mode, (IProgressMonitor)progress.newChild(10));
            this.copyExecutable(configuration, (IProgressMonitor)progress.newChild(10));
            this.doPreLaunchSynchronization(configuration, (IProgressMonitor)progress.newChild(10));
            IPDebugger debugger = null;
            try {
                if (mode.equals("debug")) {
                    progress.subTask(Messages.ParallelLaunchConfigurationDelegate_6);
                    IPDebugConfiguration debugConfig = this.getDebugConfig(configuration);
                    debugger = debugConfig.getDebugger();
                    debugger.initialize(configuration, (IProgressMonitor)progress.newChild(10));
                    if (progress.isCanceled()) {
                        return;
                    }
                } else {
                    this.switchPerspective(DebugUITools.getLaunchPerspective((ILaunchConfigurationType)configuration.getType(), (String)mode));
                }
                progress.worked(10);
                progress.subTask(Messages.ParallelLaunchConfigurationDelegate_7);
                this.submitJob(configuration, mode, (IPLaunch)launch, debugger, (IProgressMonitor)progress.newChild(40));
                progress.worked(10);
                return;
            }
            catch (CoreException e) {
                if (debugger != null) {
                    debugger.cleanup((IPLaunch)launch);
                }
                if (e.getStatus().getCode() == 8) return;
                throw e;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void terminateJob(IResourceManagerControl rm, String jobId) {
        try {
            rm.control(jobId, "TERMINATE", null);
        }
        catch (CoreException e1) {
            PTPLaunchPlugin.log(e1);
        }
    }

    protected void doCleanupLaunch(IPLaunch launch) {
        if (launch.getLaunchMode().equals("debug")) {
            try {
                IPDebugConfiguration debugConfig = this.getDebugConfig(launch.getLaunchConfiguration());
                IPDebugger debugger = debugConfig.getDebugger();
                debugger.cleanup(launch);
            }
            catch (CoreException e) {
                PTPLaunchPlugin.log(e);
            }
        }
    }

    protected void doCompleteJobLaunch(IPLaunch launch, IPDebugger debugger) {
        final String jobId = launch.getJobId();
        final IResourceManager rm = launch.getResourceManager();
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        launch.setAttribute(ElementAttributes.getIdAttributeDefinition().getId(), jobId);
        new RuntimeProcess(launch, rm, jobId, null);
        if (launch.getLaunchMode().equals("debug")) {
            try {
                this.setDefaultSourceLocator((ILaunch)launch, configuration);
                IProject project = this.verifyProject(configuration);
                final DebuggerSession session = new DebuggerSession(jobId, launch, project, debugger);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            new ProgressMonitorDialog(PTPLaunchPlugin.getActiveWorkbenchShell()).run(true, true, (IRunnableWithProgress)session);
                        }
                        catch (InterruptedException interruptedException) {
                            ParallelLaunchConfigurationDelegate.this.terminateJob((IResourceManagerControl)rm, jobId);
                        }
                        catch (InvocationTargetException e) {
                            PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_0, e.getTargetException());
                            PTPLaunchPlugin.log(e.getCause());
                            ParallelLaunchConfigurationDelegate.this.terminateJob((IResourceManagerControl)rm, jobId);
                        }
                    }
                });
            }
            catch (CoreException e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PTPLaunchPlugin.errorDialog(Messages.ParallelLaunchConfigurationDelegate_1, e.getStatus());
                        PTPLaunchPlugin.log(e);
                        ParallelLaunchConfigurationDelegate.this.terminateJob((IResourceManagerControl)rm, jobId);
                    }
                });
            }
        }
    }

    protected void showPTPDebugView(final String viewID) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        try {
                            page.showView(viewID, null, 3);
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
    }

    protected void switchPerspective(final String perspectiveID) {
        if (perspectiveID != null) {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            if (display != null && !display.isDisposed()) {
                display.syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage page;
                        IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
                        if (window != null && (page = window.getActivePage()) != null) {
                            if (page.getPerspective().getId().equals(perspectiveID)) {
                                return;
                            }
                            try {
                                window.getWorkbench().showPerspective(perspectiveID, window);
                            }
                            catch (WorkbenchException workbenchException) {}
                        }
                    }
                });
            }
        }
    }

    private void startRM(final IResourceManager rm) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    rm.start(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            IStatus status = null;
            if (t != null && t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
            }
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ParallelLaunchConfigurationDelegate_Start_rm, (String)Messages.ParallelLaunchConfigurationDelegate_Failed_to_start, status);
        }
        catch (InterruptedException interruptedException) {}
    }

    private class DebuggerSession
    implements IRunnableWithProgress {
        private final String fJobId;
        private final IPLaunch fLaunch;
        private final IProject fProject;
        private final IPDebugger fDebugger;

        public DebuggerSession(String jobId, IPLaunch launch, IProject project, IPDebugger debugger) {
            this.fJobId = jobId;
            this.fLaunch = launch;
            this.fProject = project;
            this.fDebugger = debugger;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.ParallelLaunchConfigurationDelegate_5, 10);
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                try {
                    IPSession session = PTPDebugCorePlugin.getDebugModel().createDebugSession(this.fDebugger, this.fLaunch, this.fProject, (IProgressMonitor)subMon.newChild(2));
                    String app = ParallelLaunchConfigurationDelegate.this.getProgramName(this.fLaunch.getLaunchConfiguration());
                    String path = ParallelLaunchConfigurationDelegate.this.getProgramPath(this.fLaunch.getLaunchConfiguration());
                    String cwd = ParallelLaunchConfigurationDelegate.this.getWorkingDirectory(this.fLaunch.getLaunchConfiguration());
                    String[] args = ParallelLaunchConfigurationDelegate.this.getProgramArguments(this.fLaunch.getLaunchConfiguration());
                    ParallelLaunchConfigurationDelegate.this.switchPerspective(DebugUITools.getLaunchPerspective((ILaunchConfigurationType)this.fLaunch.getLaunchConfiguration().getType(), (String)this.fLaunch.getLaunchMode()));
                    session.connectToDebugger((IProgressMonitor)subMon.newChild(8), app, path, cwd, args);
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.getDebugModel().shutdownSession(this.fJobId);
                    throw new InvocationTargetException(e, e.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

