/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.views;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.pldt.common.ArtifactManager;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.IArtifact;
import org.eclipse.ptp.pldt.common.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class SimpleTreeTableMarkerView
extends ViewPart {
    protected TreeViewer viewer;
    protected String parentMarkerAttrib = "parent";
    private Tree tree;
    protected Action infoAction;
    private Action filterAction;
    private Action doubleClickAction;
    private static final boolean traceOn = false;
    private static final boolean traceStatusLine = false;
    protected ViewerSorter nameSorter;
    protected GenericSorter lineNoSorter;
    protected FilenameSorter filenameSorter;
    protected GenericSorter orderSorter;
    protected GenericSorter nameArtifactSorter;
    protected GenericSorter constructSorter;
    private IMarker selectedMarker_ = null;
    protected StackList changedArts_ = new StackList();
    protected StackList changedMarkers_ = new StackList();
    protected UpdateVisitor visitor_ = new UpdateVisitor();
    protected String thingname_ = Messages.SimpleTreeTableMarkerView_1;
    protected String thingnames_ = Messages.SimpleTreeTableMarkerView_2;
    private String columnName_ = Messages.SimpleTreeTableMarkerView_3;
    private AbstractUIPlugin thePlugin_;
    private String iconName_ = "icons/sample.gif";
    private String viewName_;
    private String markerID_;
    protected ArtifactManager artifactManager_;
    private String[] columnNames_;
    private String[] markerAttrNames_;
    protected String uniqueID_ = "uniqueID";
    protected String columnID_ = "constructType";
    protected static final String NAME = "name";
    protected static final String FILENAME = "filename";
    protected static final String LINE = "lineNumber";
    protected static final String DESCRIPTION = "description";
    public static final int NONE = 0;
    public static final int FUNCTION_CALL = 1;
    public static final int CONSTANT = 2;
    public static final String[] CONSTRUCT_TYPE_NAMES = new String[]{Messages.SimpleTreeTableMarkerView_none, Messages.SimpleTreeTableMarkerView_function_call, Messages.SimpleTreeTableMarkerView_constant};

    public SimpleTreeTableMarkerView(AbstractUIPlugin thePlugin, String thingname, String thingnames, String columnName, String markerID, String parentMarkerAttrName) {
        this.thePlugin_ = thePlugin == null ? CommonPlugin.getDefault() : thePlugin;
        if (thingname != null) {
            this.thingname_ = thingname;
        }
        if (thingnames != null) {
            this.thingnames_ = thingnames;
        }
        if (columnName != null) {
            this.columnName_ = columnName;
        }
        this.markerID_ = markerID;
        this.parentMarkerAttrib = parentMarkerAttrName;
        this.findViewInfo();
    }

    public SimpleTreeTableMarkerView(AbstractUIPlugin thePlugin, String thingname, String thingnames, String[] attrNames, String[] colNames, String markerID, String parentMarkerAttribName) {
        this(thePlugin, thingname, thingnames, null, markerID, parentMarkerAttribName);
        this.columnNames_ = colNames;
        this.columnName_ = null;
        this.markerAttrNames_ = attrNames;
    }

    public SimpleTreeTableMarkerView() {
        this(null, null, null, null, null, null);
    }

    protected void findViewInfo() {
        String classname = ((Object)((Object)this)).getClass().getName();
        IExtension[] ext = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.views").getExtensions();
        int i = 0;
        while (i < ext.length) {
            IExtension extension = ext[i];
            IConfigurationElement[] ces = extension.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                IConfigurationElement cElement = ces[j];
                String iconName = cElement.getAttribute("icon");
                String classN = cElement.getAttribute("class");
                String name = cElement.getAttribute(NAME);
                if (classname.equals(classN)) {
                    if (iconName != null) {
                        this.iconName_ = iconName;
                    }
                    this.viewName_ = name;
                    if (this.markerID_ == null) {
                        this.markerID_ = cElement.getAttribute("id");
                    }
                    this.artifactManager_ = ArtifactManager.getManager(this.markerID_);
                    if (this.artifactManager_ == null) {
                        this.artifactManager_ = new ArtifactManager(this.markerID_);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean validForAnalysis(String filename) {
        return true;
    }

    protected IArtifact getSimpleArtifact(IMarker marker) {
        String id = null;
        IArtifact artifact = null;
        try {
            id = (String)marker.getAttribute(this.uniqueID_);
            artifact = this.artifactManager_.getArtifact(id);
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(e.getMessage()) + " ... STV, CoreException getting artifact from hashMap; " + this.thingname_ + " id=" + id);
        }
        catch (NullPointerException ne) {
            System.out.println(String.valueOf(ne.getMessage()) + " ... STV, NullPtrExcp getting artifact from hashMap;" + this.thingname_ + " id=" + id);
        }
        return artifact;
    }

    protected String getConstructStr(IMarker marker) throws CoreException {
        Integer temp = (Integer)marker.getAttribute(this.columnID_);
        if (temp != null) {
            Integer constructType = temp;
            return CONSTRUCT_TYPE_NAMES[constructType];
        }
        return " ";
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 2048);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        new TreeColumn(this.tree, 16384);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof Table) {
                    Table t = (Table)obj;
                    int n = t.getSelectionIndex();
                }
            }
        });
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.nameSorter = new NameSorter();
        this.viewer.setSorter(this.nameSorter);
        this.lineNoSorter = new LineNoSorter();
        this.nameArtifactSorter = new NameArtifactSorter();
        this.filenameSorter = new FilenameSorter();
        this.constructSorter = new ConstructSorter();
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof IMarker) {
                    SimpleTreeTableMarkerView.this.selectedMarker_ = (IMarker)obj;
                }
                SimpleTreeTableMarkerView.this.showStatusMessage("", "selectionChanged");
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SimpleTreeTableMarkerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.infoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filterAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.infoAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.infoAction);
    }

    private void makeActions() {
        this.makeShowInfoAction();
        this.makeFilterAction();
        this.makeDoubleClickAction();
    }

    protected void makeShowInfoAction() {
        this.infoAction = new Action(){

            public void run() {
                String title = String.valueOf(SimpleTreeTableMarkerView.this.thingname_) + Messages.SimpleTreeTableMarkerView_info;
                if (SimpleTreeTableMarkerView.this.selectedMarker_ != null) {
                    String idFromMarker = SimpleTreeTableMarkerView.this.selectedMarker_.getAttribute(SimpleTreeTableMarkerView.this.uniqueID_, null);
                    if (idFromMarker == null) {
                        System.out.println("ATV: exception reading marker ID");
                        return;
                    }
                    StringBuffer info = new StringBuffer();
                    IArtifact artifact = SimpleTreeTableMarkerView.this.artifactManager_.getArtifact(idFromMarker);
                    info.append(Messages.SimpleTreeTableMarkerView_fileName).append(artifact.getFileName());
                    info.append(Messages.SimpleTreeTableMarkerView_line_no).append(artifact.getLine());
                    info.append(Messages.SimpleTreeTableMarkerView_name).append(artifact.getShortName());
                    info.append(Messages.SimpleTreeTableMarkerView_description).append(artifact.getDescription());
                    MessageDialog.openInformation(null, (String)title, (String)info.toString());
                } else {
                    MessageDialog.openInformation(null, (String)title, (String)(String.valueOf(Messages.SimpleTreeTableMarkerView_No) + SimpleTreeTableMarkerView.this.thingname_ + Messages.SimpleTreeTableMarkerView_selected));
                }
            }
        };
        this.infoAction.setText(Messages.SimpleTreeTableMarkerView_show_info);
        this.infoAction.setToolTipText(String.valueOf(Messages.SimpleTreeTableMarkerView_show_info_tooltip) + this.thingname_);
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void makeFilterAction() {
        this.filterAction = new Action(){

            public void run() {
                SimpleTreeTableMarkerView.this.showMessage(String.valueOf(Messages.SimpleTreeTableMarkerView_83) + SimpleTreeTableMarkerView.this.thingnames_ + Messages.SimpleTreeTableMarkerView_84 + SimpleTreeTableMarkerView.this.thingnames_ + Messages.SimpleTreeTableMarkerView_85);
            }
        };
        this.filterAction.setText(String.valueOf(Messages.SimpleTreeTableMarkerView_86) + this.thingnames_);
        this.filterAction.setToolTipText(String.valueOf(Messages.SimpleTreeTableMarkerView_87) + this.thingnames_ + Messages.SimpleTreeTableMarkerView_88);
    }

    private void makeDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SimpleTreeTableMarkerView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (!(obj instanceof IMarker)) {
                    return;
                }
                IMarker marker = (IMarker)obj;
                try {
                    IFile f = (IFile)marker.getResource();
                    int lineNo = SimpleTreeTableMarkerView.this.getMarkerLineNo(marker);
                    if (f != null && f.exists()) {
                        IWorkbenchPage wbp = SimpleTreeTableMarkerView.this.getSite().getPage();
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)wbp, (IFile)f);
                        MarkerUtilities.setLineNumber((IMarker)marker, (int)lineNo);
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                        SimpleTreeTableMarkerView.this.showStatusMessage("", "double click action");
                    }
                }
                catch (Exception e) {
                    System.out.println("ATV.doubleclickAction: Error positioning editor page from marker line number");
                    SimpleTreeTableMarkerView.this.showStatusMessage("Error positioning editor from marker line number", "error marker goto");
                    e.printStackTrace();
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SimpleTreeTableMarkerView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)this.viewName_, (String)message);
    }

    private void showStatusMessage(String message, String debugMessage) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
        this.getViewSite().getActionBars().getStatusLineManager().update(true);
    }

    public void setFocus() {
        this.showStatusMessage("", "setFocus");
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
    }

    public void showMarker(IMarker marker) {
        System.out.println("Marker-------  IMarker.LINE_NUMBER=lineNumber");
        try {
            Map attrs = marker.getAttributes();
            for (Map.Entry e : attrs.entrySet()) {
                System.out.println("   " + e.getKey() + " " + e.getValue());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ImageDescriptor makeImageDescriptor(String iconName) {
        URL url = this.thePlugin_.find((IPath)new Path(iconName));
        ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
        return id;
    }

    protected void pushChangedInfo(IArtifact artifact, IMarker marker) {
        this.changedArts_.push(artifact);
        this.changedMarkers_.push(marker);
        this.checkUndoStatus();
    }

    protected void checkUndoStatus() {
    }

    protected int getMarkerLineNo(IMarker marker) {
        int lineNo = this.getIntAttr(marker, LINE);
        return lineNo;
    }

    protected int getIntAttr(IMarker marker, String attr) {
        String temp = null;
        try {
            temp = marker.getAttribute(attr).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ATV: Marker lineNo(" + attr + ") invalid; using 0");
            return 0;
        }
        int lineNo = 0;
        try {
            lineNo = Integer.parseInt(temp);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ATV: Marker lineNo(" + temp + " from attr " + attr + ") invalid (NumberFormatException); using 0");
        }
        return lineNo;
    }

    protected String getAttribute(IMarker marker, String attr) {
        String result = null;
        try {
            result = (String)marker.getAttribute(attr);
        }
        catch (Exception e) {
            System.out.println("** Exception getting marker attribute " + e);
            e.printStackTrace();
        }
        return result;
    }

    class ConstructSorter
    extends GenericSorter {
        ConstructSorter() {
        }

        protected String combine(String name, String file, String line, String construct) {
            StringBuffer result = new StringBuffer(construct);
            result.append(" - ");
            result.append(name);
            result.append(" - ");
            result.append(file);
            result.append(" - ");
            result.append(line);
            return result.toString();
        }
    }

    class FilenameSorter
    extends GenericSorter {
        FilenameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            int res = 0;
            try {
                IMarker m1 = (IMarker)e1;
                IMarker m2 = (IMarker)e2;
                String file1 = (String)m1.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                String file2 = (String)m2.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                res = this.ascending ? this.collator.compare(file1, file2) : this.collator.compare(file2, file1);
                if (res == 0) {
                    String line1 = m1.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    String line2 = m2.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    int l1 = Integer.parseInt(line1);
                    int l2 = Integer.parseInt(line2);
                    res = this.ascending ? l1 - l2 : l2 - l1;
                }
                if (res == 0) {
                    res = this.ascending ? this.collator.compare(SimpleTreeTableMarkerView.this.getConstructStr(m1), SimpleTreeTableMarkerView.this.getConstructStr(m2)) : this.collator.compare(SimpleTreeTableMarkerView.this.getConstructStr(m2), SimpleTreeTableMarkerView.this.getConstructStr(m1));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return res;
        }
    }

    abstract class GenericSorter
    extends ViewerSorter {
        protected boolean ascending = true;

        GenericSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int result = 0;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            Collator collator = this.getCollator();
            if (e1 instanceof IMarker) {
                try {
                    IMarker m1 = (IMarker)e1;
                    IMarker m2 = (IMarker)e2;
                    String name1 = (String)m1.getAttribute(SimpleTreeTableMarkerView.NAME);
                    String file1 = (String)m1.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                    String line1 = m1.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    String construct1 = SimpleTreeTableMarkerView.this.getConstructStr(m1);
                    String sort1 = this.combine(name1, file1, line1, construct1);
                    String name2 = (String)m2.getAttribute(SimpleTreeTableMarkerView.NAME);
                    String file2 = (String)m2.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                    String line2 = m2.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    String construct2 = SimpleTreeTableMarkerView.this.getConstructStr(m2);
                    String sort2 = this.combine(name2, file2, line2, construct2);
                    result = this.ascending ? collator.compare(sort1, sort2) : collator.compare(sort2, sort1);
                    return result;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }

        protected String combine(String name, String file, String line, String construct) {
            return null;
        }

        public void sort() {
            if (this == SimpleTreeTableMarkerView.this.viewer.getSorter()) {
                this.ascending = !this.ascending;
                SimpleTreeTableMarkerView.this.viewer.setSorter(null);
            } else {
                this.ascending = true;
            }
            SimpleTreeTableMarkerView.this.viewer.setSorter((ViewerSorter)this);
        }
    }

    class LineNoSorter
    extends GenericSorter {
        LineNoSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof IMarker) {
                try {
                    IMarker m1 = (IMarker)e1;
                    Object tempObj = m1.getAttribute(SimpleTreeTableMarkerView.LINE);
                    int line1 = 0;
                    int line2 = 0;
                    if (tempObj instanceof Integer) {
                        line1 = (Integer)tempObj;
                        IMarker m2 = (IMarker)e2;
                        tempObj = m2.getAttribute(SimpleTreeTableMarkerView.LINE);
                        assert (tempObj instanceof Integer);
                        line2 = (Integer)tempObj;
                    }
                    int result = 0;
                    result = this.ascending ? line1 - line2 : line2 - line1;
                    return result;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
    }

    class NameArtifactSorter
    extends GenericSorter {
        NameArtifactSorter() {
        }

        protected String combine(String name, String file, String line, String construct) {
            StringBuffer result = new StringBuffer(name);
            result.append(" - ");
            result.append(file);
            result.append(" - ");
            result.append(line);
            result.append(" - ");
            result.append(construct);
            return result.toString();
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ParentNode {
        private String parentAttrName;

        public ParentNode(String parentName) {
            this.parentAttrName = parentName;
        }

        public String getParentAttrName() {
            return this.parentAttrName;
        }
    }

    public class StackList {
        private LinkedList list = new LinkedList();

        public void push(Object v) {
            this.list.addFirst(v);
        }

        public Object top() {
            return this.list.getFirst();
        }

        public Object pop() {
            return this.list.removeFirst();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    public class UpdateVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            String name = resource.getName();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4) {
                    IFile f = (IFile)resource;
                    int flags = delta.getFlags();
                    int contentChanged = flags & 0x100;
                    if (SimpleTreeTableMarkerView.this.validForAnalysis(f.getName())) {
                        IMarkerDelta[] mDeltas = delta.getMarkerDeltas();
                        int len = mDeltas.length;
                        int j = 0;
                        while (j < len) {
                            IMarkerDelta delta3 = mDeltas[j];
                            IMarker m = delta3.getMarker();
                            String ln = SimpleTreeTableMarkerView.LINE;
                            String[] props = new String[]{ln};
                            SimpleTreeTableMarkerView.this.viewer.update((Object)m, props);
                            ++j;
                        }
                    }
                } else if (delta.getKind() == 1) {
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 262144) {
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 2) {
                    this.checkMarkerDeltas(delta);
                }
            }
            return true;
        }

        private void checkMarkerDeltas(IResourceDelta delta) {
            IMarkerDelta[] md1 = delta.getMarkerDeltas();
            int cfr_ignored_0 = md1.length;
        }

        private void showMarkerDeltaKind(IMarkerDelta delta3) {
            IMarker m = delta3.getMarker();
            String kind = "UNKNOWN";
            switch (delta3.getKind()) {
                case 1: {
                    kind = "ADDED";
                    break;
                }
                case 4: {
                    kind = "CHANGED";
                    break;
                }
                case 2: {
                    kind = "REMOVED";
                    break;
                }
                default: {
                    kind = "UNKNOWN";
                }
            }
            String mid = "";
            String ml = "";
            String mlpi = "";
            try {
                mid = m.getAttribute(SimpleTreeTableMarkerView.this.uniqueID_).toString();
                ml = m.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
            }
            catch (Exception e1) {
                System.out.println("ATV.UpdateVisitor error getting marker info ");
                e1.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    IResourceChangeListener {
        private IResource input;
        private List<ParentNode> parentList = new ArrayList<ParentNode>();
        private boolean hasRegistered = false;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (!this.hasRegistered) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
                this.hasRegistered = true;
            }
            if (newInput instanceof IResource) {
                this.input = (IResource)newInput;
            }
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public Object[] getElements(Object parent) {
            Object[] objs = null;
            try {
                String id = SimpleTreeTableMarkerView.this.markerID_;
                if (this.input == null) {
                    // empty if block
                }
                objs = this.input.findMarkers(id, false, 2);
                this.parentList = this.createParents(objs);
            }
            catch (CoreException e) {
                System.out.println("ATV, exception getting model elements (markers for Table view)");
                e.printStackTrace();
            }
            return this.parentList.toArray();
        }

        private List<ParentNode> createParents(Object[] objs) {
            this.parentList = new ArrayList<ParentNode>();
            IMarker[] markers = (IMarker[])objs;
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String parentName = this.getParentAttr(marker);
                if (parentName == null) {
                    parentName = "dummy";
                }
                this.getParentNode(parentName);
                ++i;
            }
            return this.parentList;
        }

        private String getParentAttr(IMarker marker) {
            String parentName = null;
            try {
                parentName = (String)marker.getAttribute(SimpleTreeTableMarkerView.this.parentMarkerAttrib);
                if (parentName == null) {
                    parentName = "dummy";
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return parentName;
        }

        private ParentNode getParentNode(String parentName, boolean createIfNeeded) {
            ParentNode parentNode2;
            for (ParentNode parentNode2 : this.parentList) {
                if (!parentNode2.parentAttrName.equals(parentName)) continue;
                return parentNode2;
            }
            parentNode2 = null;
            if (createIfNeeded) {
                parentNode2 = new ParentNode(parentName);
                this.parentList.add(parentNode2);
            }
            return parentNode2;
        }

        private ParentNode getParentNode(String parentName) {
            return this.getParentNode(parentName, false);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final IResourceDelta delta = event.getDelta();
            Control ctrl = SimpleTreeTableMarkerView.this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            ViewContentProvider.this.processResourceChangeDelta(delta);
                            ((ViewContentProvider)ViewContentProvider.this).SimpleTreeTableMarkerView.this.viewer.refresh();
                        }
                        catch (Exception e) {
                            System.out.println("ATV: Exception refreshing viewer: " + e);
                            e.printStackTrace();
                        }
                    }
                });
            }
        }

        private void printResourcesChanged(IResourceDelta delta, int indent) {
            this.printOneResourceChanged(delta, indent);
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.printResourcesChanged(children[i], indent + 1);
                ++i;
            }
        }

        private void printOneResourceChanged(IResourceDelta delta, int indent) {
            StringBuffer buf = new StringBuffer(80);
            int i = 0;
            while (i < indent) {
                buf.append("  ");
                ++i;
            }
            switch (delta.getKind()) {
                case 1: {
                    buf.append("ADDED");
                    break;
                }
                case 2: {
                    buf.append("REMOVED");
                    break;
                }
                case 4: {
                    buf.append("CHANGED");
                    this.testDelta(delta);
                    break;
                }
                default: {
                    buf.append("[");
                    buf.append(delta.getKind());
                    buf.append("]");
                }
            }
            buf.append(" ");
            buf.append(delta.getResource());
            System.out.println(buf);
        }

        private void testDelta(IResourceDelta delta) {
            System.out.print("Resource ");
            System.out.print(delta.getFullPath());
            System.out.println(" has changed.");
            int flags = delta.getFlags();
            if ((flags & 0x100) != 0) {
                System.out.println("--> Content Change");
            }
            if ((flags & 0x40000) != 0) {
                System.out.println("--> Content Replaced");
            }
            if ((flags & 0x20000) != 0) {
                System.out.println("--> Marker Change");
            }
        }

        protected void processResourceChangeDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)SimpleTreeTableMarkerView.this.visitor_);
            }
            catch (CoreException e2) {
                System.out.println("Error in PITV.processResourceChangeDelta()..");
                e2.printStackTrace();
            }
        }

        public Object[] getChildren(Object parentElement) {
            ParentNode parentnode = (ParentNode)parentElement;
            String parentName = parentnode.getParentAttrName();
            IMarker[] markers = null;
            try {
                markers = this.input.findMarkers(SimpleTreeTableMarkerView.this.markerID_, false, 2);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ArrayList<IMarker> children = new ArrayList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String parentAttr = this.getParentAttr(marker);
                if (parentAttr.equals(parentName)) {
                    children.add(marker);
                }
                ++i;
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            IMarker marker = (IMarker)element;
            ParentNode parent = this.getParent(marker, false);
            return parent;
        }

        private ParentNode getParent(IMarker marker, boolean b) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] kids = this.getChildren(element);
            return kids.length > 0;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HashMap iconHash = new HashMap();
        private IArtifact artifact;

        ViewLabelProvider() {
        }

        public String getText(Object o) {
            String temp = super.getText(o);
            return temp;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getColumnText(Object obj, int index) {
            if (obj == null) {
                System.out.println("ATV: LabelProv obj is null; index=" + index);
                return "ATV obj null";
            }
            IMarker marker = (IMarker)obj;
            try {
                switch (index) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return (String)marker.getAttribute(SimpleTreeTableMarkerView.NAME);
                    }
                    case 2: {
                        return (String)marker.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                    }
                    case 3: {
                        return marker.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    }
                    case 4: {
                        if (SimpleTreeTableMarkerView.this.columnName_ == null) break;
                        return SimpleTreeTableMarkerView.this.getConstructStr(marker);
                    }
                }
                String attrName = SimpleTreeTableMarkerView.this.markerAttrNames_[index - 4];
                return marker.getAttribute(attrName, "");
            }
            catch (CoreException coreException) {
                return "ATV error";
            }
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 0: {
                    return this.getCustomImage(obj);
                }
            }
            return null;
        }

        protected Image getCustomImage(Object obj) {
            Image img = (Image)this.iconHash.get(SimpleTreeTableMarkerView.this.iconName_);
            if (img == null) {
                Path path = new Path(SimpleTreeTableMarkerView.this.iconName_);
                URL url = SimpleTreeTableMarkerView.this.thePlugin_.find((IPath)path);
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
                img = id.createImage();
                this.iconHash.put(SimpleTreeTableMarkerView.this.iconName_, img);
            }
            return img;
        }

        public void dispose() {
            for (Image img : this.iconHash.values()) {
                img.dispose();
            }
            super.dispose();
        }
    }
}

