/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.lapi.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;
import org.eclipse.ptp.pldt.lapi.Activator;
import org.eclipse.ptp.pldt.lapi.IDs;
import org.eclipse.ptp.pldt.lapi.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LapiCASTVisitor
extends PldtAstVisitor {
    private static final String PREFIX = "LAPI_";
    boolean traceOn = false;

    public LapiCASTVisitor(List<String> includes, String fileName, boolean allowPrefixOnlyMatch, ScanReturn msr) {
        super(includes, fileName, allowPrefixOnlyMatch, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        ARTIFACT_CALL = Messages.LapiCASTVisitor_lapi_call;
        ARTIFACT_CONSTANT = Messages.LapiCASTVisitor_lapi_constant;
    }

    public int visitORIG(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            if (this.traceOn) {
                System.out.println("LAPI func signature=" + signature);
            }
            if (signature.startsWith(PREFIX) && astExpr instanceof IASTIdExpression) {
                IASTName funcName = ((IASTIdExpression)astExpr).getName();
                this.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof IASTLiteralExpression) {
            this.processMacroLiteral((IASTLiteralExpression)expression);
        } else if (expression instanceof IASTIdExpression) {
            IASTIdExpression idExpr = (IASTIdExpression)expression;
            IASTName name = idExpr.getName();
            System.out.println("LAPI idexpr " + name);
            String rawName = name.getRawSignature();
            String artName = name.toString();
            if (artName.startsWith(PREFIX)) {
                System.out.println("   found " + artName);
            }
            System.out.println("   rawName: " + rawName);
            this.processFuncName(name, expression);
        }
        return 3;
    }

    protected String getIncludesPrefID() {
        return IDs.PREF_INCLUDES;
    }

    protected IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public boolean matchesPrefix(String name) {
        name = name.toUpperCase();
        return name.startsWith(PREFIX);
    }
}

