/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.ui.pv.views;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPError;
import org.eclipse.ptp.pldt.openmp.ui.pv.PvPlugin;
import org.eclipse.ptp.pldt.openmp.ui.pv.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OpenMPProblemsView
extends ViewPart {
    private TableViewer viewer;
    private Action action1;
    private Action doubleClickAction;
    private Action removeMarkerAction;
    private String markerID_ = "org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker";
    protected UpdateVisitor visitor_ = new UpdateVisitor();
    private String iconName_ = "icons/openMPproblem.gif";
    private AbstractUIPlugin thePlugin_ = PvPlugin.getDefault();
    protected boolean traceOn = false;
    private static final String[] columns_ = new String[]{" ", Messages.OpenMPProblemsView_Description, Messages.OpenMPProblemsView_Resource, Messages.OpenMPProblemsView_InFolder, Messages.OpenMPProblemsView_Location};

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 66306);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < columns_.length) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columns_[i].length(), columns_[i].length(), true));
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(columns_[i]);
            tc.setAlignment(16384);
            tc.setResizable(true);
            ++i;
        }
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    public boolean validForAnalysis(String filename) {
        return true;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OpenMPProblemsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.removeMarkerAction);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                OpenMPProblemsView.this.showMessage(Messages.OpenMPProblemsView_action1executed);
            }
        };
        this.action1.setText(Messages.OpenMPProblemsView_action1);
        this.action1.setToolTipText(Messages.OpenMPProblemsView_action1tooltip);
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new GotoLineAction(this, (Viewer)this.viewer);
        this.makeRemoveMarkerAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OpenMPProblemsView.this.doubleClickAction.run();
            }
        });
    }

    protected void makeRemoveMarkerAction() {
        this.removeMarkerAction = new Action(){

            public void run() {
                final IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            int depth = 2;
                            wsResource.deleteMarkers(OpenMPProblemsView.this.markerID_, false, depth);
                            if ((this).OpenMPProblemsView.this.traceOn) {
                                System.out.println("markers removed id=" + OpenMPProblemsView.this.markerID_);
                            }
                        }
                        catch (CoreException coreException) {
                            System.out.println("RM: exception deleting markers.");
                        }
                    }
                };
                try {
                    runnable.run(null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        this.removeMarkerAction.setText(Messages.OpenMPProblemsView_removeMarkers);
        this.removeMarkerAction.setToolTipText(Messages.OpenMPProblemsView_removeAllMarkers);
        this.removeMarkerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.OpenMPProblemsView_SampleView, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static class GotoLineAction
    extends Action {
        protected ViewPart viewPart_ = null;
        protected Viewer viewer_ = null;

        public GotoLineAction(ViewPart viewPart, Viewer viewer) {
            this.viewPart_ = viewPart;
            this.viewer_ = viewer;
        }

        public void run() {
            ISelection selection = this.viewer_.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            IMarker marker = (IMarker)obj;
            try {
                IFile f;
                OpenMPError error = (OpenMPError)marker.getAttribute("problem");
                if (error == null) {
                    return;
                }
                String filename = String.valueOf(error.getPath()) + "/" + error.getFilename();
                IResource r = ParserUtil.getResourceForFilename((String)filename);
                IFile iFile = f = r instanceof IFile ? (IFile)r : null;
                if (f == null) {
                    return;
                }
                IWorkbenchPage wbp = this.viewPart_.getSite().getPage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)wbp, (IFile)f);
                String markerID = "org.eclipse.core.resource.textmarker";
                IMarker marker1 = f.createMarker(markerID);
                marker1.setAttribute("lineNumber", error.getLineno());
                marker1.setAttribute("location", (Object)filename);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker1);
                marker1.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    public class UpdateVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4) {
                    IFile f = (IFile)resource;
                    int flags = delta.getFlags();
                    int contentChanged = flags & 0x100;
                    if (OpenMPProblemsView.this.validForAnalysis(f.getName())) {
                        if (OpenMPProblemsView.this.traceOn) {
                            System.out.println("File " + f.getName() + " is valid for analysis so will process the change...");
                        }
                        IMarkerDelta[] mDeltas = delta.getMarkerDeltas();
                        int len = mDeltas.length;
                        int j = 0;
                        while (j < len) {
                            IMarkerDelta delta3 = mDeltas[j];
                            if (OpenMPProblemsView.this.traceOn) {
                                this.showMarkerDeltaKind(delta3);
                            }
                            IMarker m = delta3.getMarker();
                            String ln = "lineNumber";
                            if (OpenMPProblemsView.this.traceOn) {
                                System.out.println("---UpdateVisitor.visit():viewer update marker: (lineNo)");
                            }
                            String[] props = new String[]{ln};
                            OpenMPProblemsView.this.viewer.update((Object)m, props);
                            ++j;
                        }
                    } else if (OpenMPProblemsView.this.traceOn) {
                        System.out.println("File " + f.getName() + " is NOT valid for analysis so will ignore change...");
                    }
                } else if (delta.getKind() == 1) {
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 262144) {
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 2) {
                    this.checkMarkerDeltas(delta);
                }
            }
            return true;
        }

        private void checkMarkerDeltas(IResourceDelta delta) {
            IMarkerDelta[] md1 = delta.getMarkerDeltas();
            int cfr_ignored_0 = md1.length;
        }

        private void showMarkerDeltaKind(IMarkerDelta delta3) {
            String mid = "";
            String ml = "";
            String mlpi = "";
            if (OpenMPProblemsView.this.traceOn) {
                System.out.println("    markerID_=" + mid + "  lineNo(mkr-mpiA)=" + ml + "-" + mlpi);
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    IResourceChangeListener {
        private IResource input = null;
        private boolean hasRegistered = false;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (!this.hasRegistered) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
                this.hasRegistered = true;
            }
            if (newInput instanceof IResource) {
                this.input = (IResource)newInput;
            }
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public Object[] getElements(Object parent) {
            Object[] objs = null;
            try {
                String id = OpenMPProblemsView.this.markerID_;
                if (this.input != null) {
                    objs = this.input.findMarkers(id, false, 2);
                }
            }
            catch (CoreException e) {
                System.out.println("OpenMPProblemsView exception gettting model elements (markers");
                e.printStackTrace();
            }
            return objs;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final IResourceDelta delta = event.getDelta();
            Control ctrl = OpenMPProblemsView.this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        ViewContentProvider.this.processResourceChangeDelta(delta);
                        OpenMPProblemsView.this.viewer.refresh();
                    }
                });
            }
        }

        protected void processResourceChangeDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)OpenMPProblemsView.this.visitor_);
            }
            catch (CoreException e) {
                System.out.println("OpenMPProblemsView error in processResoruceChangeDelta");
                e.printStackTrace();
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private HashMap iconHash = new HashMap();

        ViewLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 0: {
                    return this.getCustomImage(obj);
                }
            }
            return null;
        }

        protected Image getCustomImage(Object obj) {
            Image img = (Image)this.iconHash.get(OpenMPProblemsView.this.iconName_);
            if (img == null) {
                Path path = new Path(OpenMPProblemsView.this.iconName_);
                URL url = OpenMPProblemsView.this.thePlugin_.find((IPath)path);
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
                img = id.createImage();
                if (OpenMPProblemsView.this.traceOn) {
                    System.out.println("ATV: ***** created image for " + OpenMPProblemsView.this.iconName_);
                }
                this.iconHash.put(OpenMPProblemsView.this.iconName_, img);
            }
            return img;
        }

        public void dispose() {
            if (OpenMPProblemsView.this.traceOn) {
                System.out.println("ATV.ViewLabelProvider.dispose(); dispose of icon images");
            }
            for (Image img : this.iconHash.values()) {
                img.dispose();
            }
            super.dispose();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getColumnText(Object obj, int index) {
            if (obj == null) {
                System.out.println("ATV: LabelProv obj is null; index=" + index);
                return "ATV obj null";
            }
            IMarker marker = (IMarker)obj;
            try {
                switch (index) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return (String)marker.getAttribute("description");
                    }
                    case 2: {
                        return (String)marker.getAttribute("resource");
                    }
                    case 3: {
                        return (String)marker.getAttribute("infoldername");
                    }
                    case 4: {
                        return ((Integer)marker.getAttribute("location")).toString();
                    }
                }
                return "";
            }
            catch (CoreException ce) {
                return "ViewLabelProvider.getColumnText error: " + (Object)((Object)ce);
            }
        }
    }
}

