/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Serializer {
    static final char[] BASE64_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    static final byte[] BASE64_ALPHABET_INVERSE;

    static {
        byte[] byArray = new byte[80];
        byArray[0] = 62;
        byArray[4] = 63;
        byArray[5] = 52;
        byArray[6] = 53;
        byArray[7] = 54;
        byArray[8] = 55;
        byArray[9] = 56;
        byArray[10] = 57;
        byArray[11] = 58;
        byArray[12] = 59;
        byArray[13] = 60;
        byArray[14] = 61;
        byArray[23] = 1;
        byArray[24] = 2;
        byArray[25] = 3;
        byArray[26] = 4;
        byArray[27] = 5;
        byArray[28] = 6;
        byArray[29] = 7;
        byArray[30] = 8;
        byArray[31] = 9;
        byArray[32] = 10;
        byArray[33] = 11;
        byArray[34] = 12;
        byArray[35] = 13;
        byArray[36] = 14;
        byArray[37] = 15;
        byArray[38] = 16;
        byArray[39] = 17;
        byArray[40] = 18;
        byArray[41] = 19;
        byArray[42] = 20;
        byArray[43] = 21;
        byArray[44] = 22;
        byArray[45] = 23;
        byArray[46] = 24;
        byArray[47] = 25;
        byArray[54] = 26;
        byArray[55] = 27;
        byArray[56] = 28;
        byArray[57] = 29;
        byArray[58] = 30;
        byArray[59] = 31;
        byArray[60] = 32;
        byArray[61] = 33;
        byArray[62] = 34;
        byArray[63] = 35;
        byArray[64] = 36;
        byArray[65] = 37;
        byArray[66] = 38;
        byArray[67] = 39;
        byArray[68] = 40;
        byArray[69] = 41;
        byArray[70] = 42;
        byArray[71] = 43;
        byArray[72] = 44;
        byArray[73] = 45;
        byArray[74] = 46;
        byArray[75] = 47;
        byArray[76] = 48;
        byArray[77] = 49;
        byArray[78] = 50;
        byArray[79] = 51;
        BASE64_ALPHABET_INVERSE = byArray;
    }

    public static String serialize(Object o) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        GZIPOutputStream zipStream = new GZIPOutputStream(buffer);
        ObjectOutputStream out = new ObjectOutputStream(zipStream);
        out.writeObject(o);
        out.close();
        return Serializer.encodeBase64(buffer.toByteArray(), 0, buffer.size());
    }

    public static Object deserialize(String data) throws IOException, ClassNotFoundException {
        byte[] buffer = Serializer.decodeBase64(data);
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
        GZIPInputStream zipStream = new GZIPInputStream(stream);
        ObjectInputStream in = new ObjectInputStream(zipStream);
        return in.readObject();
    }

    static String encodeBase64(byte[] data, int offset, int length) {
        int value;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        StringBuilder buffer = new StringBuilder();
        int remainder = length % 3;
        int i = offset;
        while (i < offset + length - remainder) {
            value = (in.read() << 16) + (in.read() << 8) + in.read();
            buffer.append(BASE64_ALPHABET[value >>> 18 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 12 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 6 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value & 0x3F]);
            i += 3;
        }
        switch (remainder) {
            case 2: {
                value = (in.read() << 16) + (in.read() << 8);
                buffer.append(BASE64_ALPHABET[value >>> 18 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value >>> 12 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value >>> 6 & 0x3F]);
                buffer.append('=');
                break;
            }
            case 1: {
                value = in.read() << 16;
                buffer.append(BASE64_ALPHABET[value >>> 18 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value >>> 12 & 0x3F]);
                buffer.append('=');
                buffer.append('=');
            }
        }
        return buffer.toString();
    }

    static byte[] decodeBase64(String data) {
        int value;
        int paddingLength = 0;
        int i = 1;
        while (i < 3) {
            if (data.charAt(data.length() - i) != '=') break;
            ++paddingLength;
            ++i;
        }
        int length = data.length() / 4 * 3 - paddingLength;
        int bytesDecoded = 0;
        byte[] buffer = new byte[length];
        int charactersToRead = paddingLength > 0 ? data.length() - 4 : data.length();
        int i2 = 0;
        while (i2 < charactersToRead) {
            value = (BASE64_ALPHABET_INVERSE[data.charAt(i2) - 43] << 18) + (BASE64_ALPHABET_INVERSE[data.charAt(i2 + 1) - 43] << 12) + (BASE64_ALPHABET_INVERSE[data.charAt(i2 + 2) - 43] << 6) + BASE64_ALPHABET_INVERSE[data.charAt(i2 + 3) - 43];
            buffer[bytesDecoded++] = Integer.valueOf(value >>> 16 & 0xFF).byteValue();
            buffer[bytesDecoded++] = Integer.valueOf(value >>> 8 & 0xFF).byteValue();
            buffer[bytesDecoded++] = Integer.valueOf(value & 0xFF).byteValue();
            i2 += 4;
        }
        switch (paddingLength) {
            case 2: {
                value = (BASE64_ALPHABET_INVERSE[data.charAt(i2) - 43] << 18) + (BASE64_ALPHABET_INVERSE[data.charAt(i2 + 1) - 43] << 12);
                buffer[bytesDecoded++] = (byte)(value >>> 16 & 0xFF);
                break;
            }
            case 1: {
                value = (BASE64_ALPHABET_INVERSE[data.charAt(i2) - 43] << 18) + (BASE64_ALPHABET_INVERSE[data.charAt(i2 + 1) - 43] << 12) + (BASE64_ALPHABET_INVERSE[data.charAt(i2 + 2) - 43] << 6);
                buffer[bytesDecoded++] = (byte)(value >>> 16 & 0xFF);
                buffer[bytesDecoded++] = (byte)(value >>> 8 & 0xFF);
            }
        }
        return buffer;
    }
}

