/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.includebrowser;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.LocalIncludeBrowserService;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class IncludeBrowserServiceFactory {
    public IIncludeBrowserService getIncludeBrowserService(ICProject project) {
        String[] natures;
        IProjectDescription description;
        if (project == null) {
            return null;
        }
        boolean remoteProject = false;
        try {
            description = project.getProject().getDescription();
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        String[] stringArray = natures = description.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if ("org.eclipse.ptp.rdt.core.remoteNature".equals(nature)) {
                remoteProject = true;
                break;
            }
            ++n2;
        }
        if (remoteProject) {
            IService indexingService;
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project.getProject());
            IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
            if (serviceProvider instanceof IIndexServiceProvider) {
                IIncludeBrowserService service = ((IIndexServiceProvider)serviceProvider).getIncludeBrowserService();
                return service;
            }
        } else {
            return new LocalIncludeBrowserService();
        }
        return null;
    }
}

