/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.includebrowser;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.includebrowser.AbstractIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.rdt.core.RDTLog;

public class LocalIncludeBrowserService
extends AbstractIncludeBrowserService {
    private static final IIndexIncludeValue[] EMPTY = new IIndexIncludeValue[0];

    private IIndexInclude[] findIncludedBy(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludedBy(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    int i = 0;
                    while (i < files.length) {
                        IIndexInclude[] includes = index.findIncludedBy(files[i]);
                        int j = 0;
                        while (j < includes.length) {
                            IIndexInclude indexInclude = includes[j];
                            if (handled.add(indexInclude.getIncludedByLocation())) {
                                list.add(indexInclude);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return new IIndexInclude[0];
    }

    private IIndexInclude[] findIncludesTo(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludes(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    int i = 0;
                    while (i < files.length) {
                        IIndexInclude[] includes = index.findIncludes(files[i]);
                        int j = 0;
                        while (j < includes.length) {
                            IIndexInclude indexInclude = includes[j];
                            if (handled.add(indexInclude.getIncludesLocation())) {
                                list.add(indexInclude);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return new IIndexInclude[0];
    }

    public IIndexIncludeValue[] findIncludedBy(IIndexFileLocation ifl, ICProject project, IProgressMonitor progress) {
        IIndex index = null;
        try {
            ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
            index = CCorePlugin.getIndexManager().getIndex(scope);
            index.acquireReadLock();
            IIndexInclude[] includes = this.findIncludedBy(index, ifl, progress);
            IIndexIncludeValue[] includeValues = new IIndexIncludeValue[includes.length];
            int i = 0;
            while (i < includes.length) {
                includeValues[i] = new IndexIncludeValue(includes[i]);
                ++i;
            }
            IIndexIncludeValue[] iIndexIncludeValueArray = includeValues;
            return iIndexIncludeValueArray;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            IIndexIncludeValue[] iIndexIncludeValueArray = EMPTY;
            return iIndexIncludeValueArray;
        }
        catch (InterruptedException interruptedException) {
            IIndexIncludeValue[] iIndexIncludeValueArray = EMPTY;
            return iIndexIncludeValueArray;
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
    }

    public IIndexIncludeValue[] findIncludesTo(IIndexFileLocation ifl, ICProject project, IProgressMonitor progress) {
        IIndex index = null;
        try {
            ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
            index = CCorePlugin.getIndexManager().getIndex(scope);
            index.acquireReadLock();
            IIndexInclude[] includes = this.findIncludesTo(index, ifl, progress);
            IIndexIncludeValue[] includeValues = new IIndexIncludeValue[includes.length];
            int i = 0;
            while (i < includes.length) {
                includeValues[i] = new IndexIncludeValue(includes[i]);
                ++i;
            }
            IIndexIncludeValue[] iIndexIncludeValueArray = includeValues;
            return iIndexIncludeValueArray;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            IIndexIncludeValue[] iIndexIncludeValueArray = EMPTY;
            return iIndexIncludeValueArray;
        }
        catch (InterruptedException interruptedException) {
            IIndexIncludeValue[] iIndexIncludeValueArray = EMPTY;
            return iIndexIncludeValueArray;
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
    }

    public IIndexIncludeValue findInclude(IInclude input, IProgressMonitor monitor) throws CoreException {
        ICProject project = input.getCProject();
        if (project != null) {
            IndexIncludeValue indexIncludeValue;
            IIndex index = CCorePlugin.getIndexManager().getIndex(project);
            index.acquireReadLock();
            try {
                IIndexInclude include = IndexQueries.elementToInclude(index, input);
                indexIncludeValue = new IndexIncludeValue(include);
            }
            catch (Throwable throwable) {
                try {
                    index.releaseReadLock();
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            index.releaseReadLock();
            return indexIncludeValue;
        }
        return null;
    }

    public boolean isIndexed(IIndexFileLocation location, ICProject project, IProgressMonitor monitor) {
        block6: {
            boolean bl;
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
            index.acquireReadLock();
            try {
                IIndexFile[] files = index.getFiles(location);
                bl = files.length > 0;
            }
            catch (Throwable throwable) {
                try {
                    index.releaseReadLock();
                    throw throwable;
                }
                catch (CoreException e) {
                    RDTLog.logError(e);
                    break block6;
                }
                catch (InterruptedException e) {
                    RDTLog.logError(e);
                }
            }
            index.releaseReadLock();
            return bl;
        }
        return false;
    }
}

