/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;

public class UserFile {
    private static final String RDT_SETTINGS_DIRECTORY = ".rdt";

    private UserFile() {
    }

    public static File get(String fileName) {
        File settingsDir = UserFile.getSettingsDirectory();
        if (settingsDir == null) {
            return null;
        }
        return new File(String.valueOf(settingsDir.toString()) + File.separator + fileName);
    }

    public static File getSettingsDirectory() {
        File userDir = UserFile.getSettingsDirectoryInUserHome();
        if (userDir.exists()) {
            return userDir;
        }
        if (userDir.mkdir()) {
            return userDir;
        }
        File currentDir = UserFile.getCurrentDirectory();
        if (currentDir.exists()) {
            return currentDir;
        }
        return null;
    }

    private static File getSettingsDirectoryInUserHome() {
        String userHome = System.getProperties().getProperty("user.home");
        return new File(String.valueOf(userHome) + File.separator + RDT_SETTINGS_DIRECTORY);
    }

    private static File getCurrentDirectory() {
        return new File(System.getProperties().getProperty("user.dir"));
    }
}

