/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchElement;

public class RemoteLineSearchElement
extends RemoteSearchElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int fOffset;
    private final int fNumber;
    private final String fContent;
    private final RemoteLineSearchElementMatch[] fMatches;
    public static final MatchesComparator MATCHES_COMPARATOR = new MatchesComparator();

    public RemoteLineSearchElement(IIndexFileLocation file, RemoteLineSearchElementMatch[] matches, int number, String content, int offset) {
        super(file);
        this.fMatches = matches;
        this.fNumber = number;
        int index = 0;
        int length = content.length();
        int firstMatchOffset = matches[0].getOffset();
        while (offset < firstMatchOffset && length > 0) {
            if (!Character.isWhitespace(content.charAt(index))) break;
            ++index;
            ++offset;
            --length;
        }
        this.fOffset = offset;
        this.fContent = content.substring(index).trim();
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLineNumber() {
        return this.fNumber;
    }

    public String getContent() {
        return this.fContent;
    }

    public RemoteLineSearchElementMatch[] getMatches() {
        return this.fMatches;
    }

    public String toString() {
        return String.valueOf(this.fNumber) + ": " + this.fContent;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteLineSearchElement)) {
            return false;
        }
        RemoteLineSearchElement other = (RemoteLineSearchElement)obj;
        return this.fOffset == other.fOffset && super.equals(obj) && this.fMatches.equals(other.fMatches);
    }

    public int hashCode() {
        return this.fOffset + 31 * (super.hashCode() + 31 * this.fMatches.hashCode());
    }

    private static IFile getFile(IIndexFileLocation fileLocation) {
        if (fileLocation.getFullPath() != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileLocation.getFullPath()));
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(fileLocation.getURI());
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static RemoteLineSearchElement[] createElements(IIndexFileLocation fileLocation, RemoteLineSearchElementMatch[] matches) {
        AbstractCharArray buf;
        Arrays.sort(matches, MATCHES_COMPARATOR);
        RemoteLineSearchElement[] result = new RemoteLineSearchElement[]{};
        FileContent content = FileContent.create((IIndexFileLocation)fileLocation);
        if (content != null && (buf = ((InternalFileContent)content).getSource()) != null) {
            result = RemoteLineSearchElement.collectLineElements(buf, matches, fileLocation);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static RemoteLineSearchElement[] collectLineElements(AbstractCharArray buf, RemoteLineSearchElementMatch[] matches, IIndexFileLocation fileLocation) {
        result = new ArrayList<RemoteLineSearchElement>();
        matchCollector = new ArrayList<RemoteLineSearchElementMatch>();
        skipLF = false;
        lineNumber = 1;
        lineOffset = 0;
        i = 0;
        match = matches[i];
        matchOffset = match.getOffset();
        pos = 0;
        while (buf.isValidOffset(pos)) {
            if (matchOffset <= pos && match != null) {
                matchCollector.add(match);
                minOffset = matchOffset + match.getLength();
                match = null;
                matchOffset = 0x7FFFFFFF;
                ++i;
                while (i < matches.length) {
                    nextMatch = matches[i];
                    nextOffset = nextMatch.getOffset();
                    if (nextOffset >= minOffset) {
                        match = nextMatch;
                        matchOffset = nextOffset;
                        break;
                    }
                    ++i;
                }
            }
            c = buf.get(pos);
            if (!skipLF) ** GOTO lbl-1000
            skipLF = false;
            if (c == '\n') {
                lineOffset = pos + 1;
            } else if (c == '\n' || c == '\r') {
                if (!matchCollector.isEmpty()) {
                    lineLength = pos - lineOffset;
                    lineMatches = matchCollector.toArray(new RemoteLineSearchElementMatch[matchCollector.size()]);
                    lineChars = new char[lineLength];
                    buf.arraycopy(lineOffset, lineChars, 0, lineLength);
                    lineContent = new String(lineChars);
                    result.add(new RemoteLineSearchElement(fileLocation, lineMatches, lineNumber, lineContent, lineOffset));
                    matchCollector.clear();
                    if (match == null) break;
                }
                ++lineNumber;
                lineOffset = pos + 1;
                if (c == '\r') {
                    skipLF = true;
                }
            }
            ++pos;
        }
        if (!matchCollector.isEmpty()) {
            lineLength = buf.getLength() - lineOffset;
            lineMatches = matchCollector.toArray(new RemoteLineSearchElementMatch[matchCollector.size()]);
            lineChars = new char[lineLength];
            buf.arraycopy(lineOffset, lineChars, 0, lineLength);
            lineContent = new String(lineChars);
            result.add(new RemoteLineSearchElement(fileLocation, lineMatches, lineNumber, lineContent, lineOffset));
        }
        return result.toArray(new RemoteLineSearchElement[result.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatchesComparator
    implements Comparator<RemoteLineSearchElementMatch> {
        private MatchesComparator() {
        }

        @Override
        public int compare(RemoteLineSearchElementMatch m1, RemoteLineSearchElementMatch m2) {
            int diff = m1.getOffset() - m2.getOffset();
            if (diff == 0) {
                diff = m2.getLength() - m1.getLength();
            }
            return diff;
        }
    }

    public static class RemoteLineSearchElementMatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int fOffset;
        private final int fLength;
        private final boolean fIsPolymorphicCall;
        private final ICElement fEnclosingElement;
        private final boolean fIsWriteAccess;

        public RemoteLineSearchElementMatch(int offset, int length, boolean isPolymorphicCall, ICElement enclosingElement, boolean isWriteAccess) {
            this.fOffset = offset;
            this.fLength = length;
            this.fIsPolymorphicCall = isPolymorphicCall;
            this.fEnclosingElement = enclosingElement;
            this.fIsWriteAccess = isWriteAccess;
        }

        public int getOffset() {
            return this.fOffset;
        }

        public int getLength() {
            return this.fLength;
        }

        public boolean isPolymorphicCall() {
            return this.fIsPolymorphicCall;
        }

        public ICElement getEnclosingElement() {
            return this.fEnclosingElement;
        }

        public boolean isWriteAccess() {
            return this.fIsWriteAccess;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoteLineSearchElementMatch)) {
                return false;
            }
            RemoteLineSearchElementMatch m = (RemoteLineSearchElementMatch)obj;
            return this.fOffset == m.fOffset && this.fLength == m.fLength;
        }

        public int hashCode() {
            return 31 * this.fOffset + this.fLength;
        }
    }
}

