/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerInfoUtility {
    public static ConsoleOutputSniffer createBuildOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, IConfiguration cfg, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        ICfgScannerConfigBuilderInfo2Set container = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        Map map = container.getInfoMap();
        List<Object> clParserList = new ArrayList();
        HashMap<String, Set<CfgInfoContext>> profileIDToConfigContextMap = new HashMap<String, Set<CfgInfoContext>>();
        if (container.isPerRcTypeDiscovery()) {
            IResourceInfo[] rcInfos = cfg.getResourceInfos();
            int q = 0;
            while (q < rcInfos.length) {
                IResourceInfo rcInfo = rcInfos[q];
                ITool[] tools = rcInfo instanceof IFileInfo ? ((IFileInfo)rcInfo).getToolsToInvoke() : ((IFolderInfo)rcInfo).getFilteredTools();
                int i = 0;
                while (i < tools.length) {
                    ITool tool = tools[i];
                    IInputType[] types = tool.getInputTypes();
                    if (types.length != 0) {
                        int k = 0;
                        while (k < types.length) {
                            IInputType type = types[k];
                            CfgInfoContext c = new CfgInfoContext(rcInfo, tool, type);
                            ScannerInfoUtility.contributeToProfileSet(project, map, c, workingDirectory, profileIDToConfigContextMap);
                            ++k;
                        }
                    } else {
                        CfgInfoContext c = new CfgInfoContext(rcInfo, tool, null);
                        ScannerInfoUtility.contributeToProfileSet(project, map, c, workingDirectory, profileIDToConfigContextMap);
                    }
                    ++i;
                }
                ++q;
            }
        }
        if (profileIDToConfigContextMap.size() == 0) {
            ScannerInfoUtility.contributeToProfileSet(project, map, new CfgInfoContext(cfg), workingDirectory, profileIDToConfigContextMap);
        }
        if (profileIDToConfigContextMap.size() != 0) {
            clParserList = ScannerInfoUtility.contributeToConsoleParserList(project, map, workingDirectory, markerGenerator, collector, profileIDToConfigContextMap);
        }
        if (clParserList.size() != 0) {
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])clParserList.toArray(new IScannerInfoConsoleParser[clParserList.size()]));
        }
        return null;
    }

    private static void contributeToProfileSet(IProject project, Map<CfgInfoContext, IScannerConfigBuilderInfo2> map, CfgInfoContext context, IPath workingDirectory, Map<String, Set<CfgInfoContext>> profileIDToConfigInfoMap) {
        ITool tool;
        IScannerConfigBuilderInfo2 info = map.get(context);
        if (info != null && info.isAutoDiscoveryEnabled() && info.isBuildOutputParserEnabled() && (tool = context.getTool()) != null) {
            IInputType[] inputTypes;
            IInputType[] iInputTypeArray = inputTypes = tool.getInputTypes();
            int n = inputTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IInputType inputType = iInputTypeArray[n2];
                if (inputType != null) {
                    String[] profileIDs;
                    InputType realInputType = (InputType)inputType;
                    String profileIDString = realInputType.getDiscoveryProfileIdAttribute();
                    String[] stringArray = profileIDs = profileIDString.split("\\|");
                    int n3 = profileIDs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String profileID = stringArray[n4];
                        if (profileID != null) {
                            Set<CfgInfoContext> thisProfileContextSet = profileIDToConfigInfoMap.get(profileID);
                            if (thisProfileContextSet == null) {
                                thisProfileContextSet = new HashSet<CfgInfoContext>();
                            }
                            thisProfileContextSet.add(context);
                            profileIDToConfigInfoMap.put(profileID, thisProfileContextSet);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private static List<IScannerInfoConsoleParser> contributeToConsoleParserList(IProject project, Map<CfgInfoContext, IScannerConfigBuilderInfo2> map, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector, Map<String, Set<CfgInfoContext>> profileIDToConfigInfoMap) {
        ArrayList<IScannerInfoConsoleParser> clParserList = new ArrayList<IScannerInfoConsoleParser>();
        for (String profileId : profileIDToConfigInfoMap.keySet()) {
            ScannerConfigProfile profile;
            if (profileId == null || (profile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId)).getBuildOutputProviderElement() == null) continue;
            Set<CfgInfoContext> profileConextSet = profileIDToConfigInfoMap.get(profileId);
            ArrayList<CfgInfoContext> handledProfileConextList = new ArrayList<CfgInfoContext>();
            Iterator<CfgInfoContext> orginalProfileConextIter = profileConextSet.iterator();
            if (orginalProfileConextIter.hasNext()) {
                CfgInfoContext firstConext = orginalProfileConextIter.next();
                handledProfileConextList.add(firstConext);
                IScannerConfigBuilderInfo2 info = map.get(firstConext);
                InfoContext ic = firstConext.toInfoContext();
                SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic, profileId);
                IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                clParser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info.isProblemReportingEnabled() ? markerGenerator : null));
                clParserList.add(clParser);
            }
            while (orginalProfileConextIter.hasNext()) {
                CfgInfoContext thisContext = orginalProfileConextIter.next();
                boolean skipThisContext = false;
                for (CfgInfoContext handledContext : handledProfileConextList) {
                    if (!ScannerInfoUtility.doContextsGenerateSameParser(project, map, collector, profileId, handledContext, thisContext)) continue;
                    skipThisContext = true;
                    break;
                }
                if (skipThisContext) continue;
                handledProfileConextList.add(thisContext);
                IScannerConfigBuilderInfo2 info = map.get(thisContext);
                InfoContext ic = thisContext.toInfoContext();
                SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic, profileId);
                IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                clParser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info.isProblemReportingEnabled() ? markerGenerator : null));
                clParserList.add(clParser);
            }
        }
        return clParserList;
    }

    private static boolean doContextsGenerateSameParser(IProject project, Map<CfgInfoContext, IScannerConfigBuilderInfo2> map, IScannerInfoCollector collector, String profileID, CfgInfoContext context_1, CfgInfoContext context_2) {
        InfoContext ic_1 = context_1.toInfoContext();
        SCProfileInstance profileInstance_1 = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic_1, profileID);
        IScannerInfoConsoleParser clParser_1 = profileInstance_1.createBuildOutputParser();
        InfoContext ic_2 = context_2.toInfoContext();
        SCProfileInstance profileInstance_2 = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic_2, profileID);
        IScannerInfoConsoleParser clParser_2 = profileInstance_2.createBuildOutputParser();
        if (!clParser_1.getClass().getName().equals(clParser_2.getClass().getName())) {
            return false;
        }
        if (collector == null) {
            IScannerInfoCollector collector_1 = profileInstance_1.getScannerInfoCollector();
            IScannerInfoCollector collector_2 = profileInstance_2.getScannerInfoCollector();
            if (!collector_1.getClass().getName().equals(collector_2.getClass().getName())) {
                return false;
            }
        }
        IScannerConfigBuilderInfo2 info_1 = map.get(context_1);
        IScannerConfigBuilderInfo2 info_2 = map.get(context_2);
        return info_1.isProblemReportingEnabled() == info_2.isProblemReportingEnabled();
    }
}

