/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.RemoteContentProvider;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;

public class BinaryResourceMatcher
extends ResourceMatcher {
    public boolean match(IResource candidate) {
        if (!(candidate instanceof IFile)) {
            return false;
        }
        if (BinaryResourceMatcher.isCDTBinary((IFile)candidate)) {
            return true;
        }
        return BinaryResourceMatcher.isELFBinary((IFile)candidate);
    }

    private static boolean isCDTBinary(IFile candidate) {
        ICElement fileElement;
        block3: {
            try {
                fileElement = CoreModel.getDefault().create(candidate.getFullPath());
                if (fileElement != null) break block3;
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        int resType = fileElement.getElementType();
        return resType == 14;
    }

    private static boolean isELFBinary(IFile candidate) {
        BufferedInputStream fileInput = null;
        try {
            fileInput = candidate.exists() ? new BufferedInputStream(candidate.getContents()) : RemoteContentProvider.getFileContents(candidate);
            byte[] magicNumber = new byte[4];
            fileInput.read(magicNumber);
            return magicNumber[0] == 127 && magicNumber[1] == 69 && magicNumber[2] == 76 && magicNumber[3] == 70;
            {
            }
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BinaryResourceMatcher_1) + candidate.getProjectRelativePath().toString(), e);
            return false;
        }
        catch (IOException e) {
            RDTSyncCorePlugin.log(String.valueOf(Messages.BinaryResourceMatcher_1) + candidate.getProjectRelativePath().toString(), e);
            return false;
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    RDTSyncCorePlugin.log(e);
                }
            }
        }
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return o instanceof BinaryResourceMatcher;
    }

    public String toString() {
        return Messages.BinaryResourceMatcher_0;
    }
}

