/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.sync.core.PathResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.messages.Messages;
import org.eclipse.ui.IMemento;

public class SyncFileFilter {
    private static final String PATTERN_ELEMENT_NAME = "pattern";
    private static final String PATTERN_INTERNAL_ELEMENT_NAME = "pattern";
    private static final String ATTR_PATTERN_RANK = "pattern-rank";
    private static final String ATTR_PATTERN_TYPE = "pattern-type";
    private static final String ATTR_NUM_PATTERNS = "num-patterns";
    private final LinkedList<ResourceMatcher> filteredPaths = new LinkedList();
    private final Map<ResourceMatcher, PatternType> patternToTypeMap = new HashMap<ResourceMatcher, PatternType>();

    private SyncFileFilter() {
    }

    public SyncFileFilter(SyncFileFilter oldFilter) {
        this.filteredPaths.addAll(oldFilter.filteredPaths);
        this.patternToTypeMap.putAll(oldFilter.patternToTypeMap);
    }

    public static SyncFileFilter createEmptyFilter() {
        return new SyncFileFilter();
    }

    public static SyncFileFilter createBuiltInDefaultFilter() {
        SyncFileFilter sff = new SyncFileFilter();
        sff.addDefaults();
        return sff;
    }

    public ResourceMatcher[] getPatterns() {
        return this.filteredPaths.toArray(new ResourceMatcher[this.filteredPaths.size()]);
    }

    public PatternType getPatternType(ResourceMatcher pattern) {
        return this.patternToTypeMap.get(pattern);
    }

    public void addDefaults() {
        this.addPattern(new PathResourceMatcher((IPath)new Path(".project")), PatternType.EXCLUDE);
        this.addPattern(new PathResourceMatcher((IPath)new Path(".cproject")), PatternType.EXCLUDE);
        this.addPattern(new PathResourceMatcher((IPath)new Path(".settings")), PatternType.EXCLUDE);
        this.addPattern(new PathResourceMatcher((IPath)new Path(".ptp-sync")), PatternType.EXCLUDE);
    }

    public void addPattern(ResourceMatcher pattern, PatternType type) {
        if (this.patternToTypeMap.get(pattern) != null) {
            this.filteredPaths.remove(pattern);
        }
        this.filteredPaths.add(0, pattern);
        this.patternToTypeMap.put(pattern, type);
    }

    public void removePattern(ResourceMatcher pattern) {
        this.filteredPaths.remove(pattern);
        this.patternToTypeMap.remove(pattern);
    }

    public boolean promote(ResourceMatcher pattern) {
        int oldIndex = this.filteredPaths.indexOf(pattern);
        if (oldIndex > 0) {
            this.filteredPaths.remove(oldIndex);
            this.filteredPaths.add(oldIndex - 1, pattern);
            return true;
        }
        return false;
    }

    public boolean demote(ResourceMatcher pattern) {
        int oldIndex = this.filteredPaths.indexOf(pattern);
        if (oldIndex > -1 && oldIndex < this.filteredPaths.size() - 1) {
            this.filteredPaths.remove(oldIndex);
            this.filteredPaths.add(oldIndex + 1, pattern);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldIgnore(IResource r) {
        if (r instanceof IFolder) {
            try {
                IResource[] iResourceArray = ((IFolder)r).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (!this.shouldIgnore(member)) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        for (ResourceMatcher pm : this.filteredPaths) {
            if (!pm.match(r)) continue;
            PatternType type = this.patternToTypeMap.get(pm);
            assert (pm != null);
            return type == PatternType.EXCLUDE;
        }
        return false;
    }

    public void saveFilter(IMemento memento) {
        memento.putInteger(ATTR_NUM_PATTERNS, this.filteredPaths.size());
        for (ResourceMatcher pm : this.filteredPaths) {
            IMemento pathMemento = memento.createChild("pattern");
            IMemento patternInternalMemento = pathMemento.createChild("pattern");
            pm.saveMatcher(patternInternalMemento);
            pathMemento.putInteger(ATTR_PATTERN_RANK, this.filteredPaths.indexOf(pm));
            pathMemento.putString(ATTR_PATTERN_TYPE, this.patternToTypeMap.get(pm).name());
        }
    }

    public static SyncFileFilter loadFilter(IMemento memento) {
        int numPatterns = memento.getInteger(ATTR_NUM_PATTERNS);
        ResourceMatcher[] pmArray = new ResourceMatcher[numPatterns];
        PatternType[] typeArray = new PatternType[numPatterns];
        SyncFileFilter filter = SyncFileFilter.createEmptyFilter();
        IMemento[] iMementoArray = memento.getChildren("pattern");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                ResourceMatcher pm;
                IMemento pathMemento = iMementoArray[n2];
                IMemento patternInternalMemento = pathMemento.getChild("pattern");
                try {
                    pm = ResourceMatcher.loadMatcher(patternInternalMemento);
                }
                catch (InvocationTargetException e) {
                    RDTSyncCorePlugin.log(String.valueOf(Messages.SyncFileFilter_0) + e.getMessage(), e);
                    break block5;
                }
                catch (ParserConfigurationException e) {
                    RDTSyncCorePlugin.log(String.valueOf(Messages.SyncFileFilter_0) + e.getMessage(), e);
                    break block5;
                }
                int rank = pathMemento.getInteger(ATTR_PATTERN_RANK);
                String type = pathMemento.getString(ATTR_PATTERN_TYPE);
                pmArray[rank] = pm;
                typeArray[rank] = PatternType.valueOf(type);
            }
            ++n2;
        }
        int i = pmArray.length - 1;
        while (i >= 0) {
            filter.addPattern(pmArray[i], typeArray[i]);
            --i;
        }
        return filter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PatternType {
        EXCLUDE,
        INCLUDE;

    }
}

