/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.git.ui;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ptp.rdt.sync.core.serviceproviders.ISyncServiceProvider;
import org.eclipse.ptp.rdt.sync.git.core.GitServiceProvider;
import org.eclipse.ptp.rdt.sync.git.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipant;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GitParticipant
implements ISynchronizeParticipant {
    private static final String FILE_SCHEME = "file";
    private IRemoteConnection fSelectedConnection;
    private IRemoteServices fSelectedProvider;
    private String fProjectName = "";
    private final Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private final Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private Button fBrowseButton;
    private Button fNewConnectionButton;
    private Combo fProviderCombo;
    private Combo fConnectionCombo;
    private Text fLocationText;
    private IWizardContainer container;

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fConnectionCombo.getShell(), null, this.fSelectedConnection);
        }
    }

    public void createConfigurationArea(Composite parent, IRunnableContext context) {
        this.container = (IWizardContainer)context;
        Composite configArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        configArea.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        configArea.setLayoutData((Object)gd);
        Label providerLabel = new Label(configArea, 16384);
        providerLabel.setText(Messages.GitParticipant_remoteProvider);
        this.fProviderCombo = new Combo(configArea, 12);
        gd = new GridData(1, 1, false, false);
        gd.horizontalSpan = 2;
        this.fProviderCombo.setLayoutData((Object)gd);
        this.fProviderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitParticipant.this.handleServicesSelected();
            }
        });
        IRemoteServices[] providers = PTPRemoteUIPlugin.getDefault().getRemoteServices(context);
        int toSelect = 0;
        int k = 0;
        while (k < providers.length) {
            this.fProviderCombo.add(providers[k].getName(), k);
            if (providers[k].getName().equals("Remote Tools")) {
                toSelect = k;
            }
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            ++k;
        }
        this.fProviderCombo.select(toSelect);
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(toSelect);
        Label connectionLabel = new Label(configArea, 16384);
        connectionLabel.setText(Messages.GitParticipant_connection);
        this.fConnectionCombo = new Combo(configArea, 12);
        this.fConnectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fConnectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitParticipant.this.handleConnectionSelected();
            }
        });
        this.populateConnectionCombo(this.fConnectionCombo);
        this.fNewConnectionButton = new Button(configArea, 8);
        this.fNewConnectionButton.setText(Messages.GitParticipant_new);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.fNewConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = GitParticipant.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(GitParticipant.this.fNewConnectionButton.getShell());
                }
                GitParticipant.this.populateConnectionCombo(GitParticipant.this.fConnectionCombo);
                GitParticipant.this.update();
            }
        });
        Label locationLabel = new Label(configArea, 16384);
        locationLabel.setText(Messages.GitParticipant_location);
        this.fLocationText = new Text(configArea, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fLocationText.setLayoutData((Object)gd);
        this.fLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GitParticipant.this.update();
            }
        });
        this.handleConnectionSelected();
        this.fBrowseButton = new Button(configArea, 8);
        this.fBrowseButton.setText(Messages.GitParticipant_browse);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GitParticipant.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    GitParticipant.this.checkConnection();
                    if (GitParticipant.this.fSelectedConnection.isOpen() && (remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(GitParticipant.this.fSelectedProvider)) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(GitParticipant.this.fSelectedConnection);
                        String correctPath = GitParticipant.this.fLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(GitParticipant.this.fLocationText.getShell(), "Project Location (" + GitParticipant.this.fSelectedConnection.getName() + ")", correctPath, 0);
                        if (selectedPath != null) {
                            GitParticipant.this.fLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
    }

    private String getDefaultPathDisplayString() {
        if (this.fSelectedConnection != null && this.fSelectedConnection.isOpen()) {
            IRemoteFileManager fileMgr = this.fSelectedProvider.getFileManager(this.fSelectedConnection);
            URI defaultURI = fileMgr.toURI(this.fSelectedConnection.getWorkingDirectory());
            if (defaultURI != null && defaultURI.getScheme().equals(FILE_SCHEME)) {
                return Platform.getLocation().append(this.fProjectName).toOSString();
            }
            if (defaultURI == null) {
                return "";
            }
            return new Path(defaultURI.getPath()).append(this.fProjectName).toOSString();
        }
        return "";
    }

    public String getErrorMessage() {
        if (this.fSelectedProvider == null) {
            return Messages.GitParticipant_0;
        }
        if (this.fSelectedConnection == null) {
            return Messages.GitParticipant_1;
        }
        if (this.fLocationText.getText().length() == 0) {
            return Messages.GitParticipant_2;
        }
        IRemoteFileManager fileManager = this.fSelectedProvider.getFileManager(this.fSelectedConnection);
        if (fileManager.toURI(this.fLocationText.getText()) == null) {
            return Messages.GitParticipant_3;
        }
        return null;
    }

    public ISyncServiceProvider getProvider(IProject project) {
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IService syncService = smm.getService("org.eclipse.ptp.rdt.sync.core.SyncService");
        GitServiceProvider provider = (GitServiceProvider)smm.getServiceProvider(syncService.getProviderDescriptor("org.eclipse.ptp.rdt.sync.git.core.GitServiceProvider"));
        provider.setLocation(this.fLocationText.getText());
        provider.setRemoteConnection(this.fSelectedConnection);
        provider.setRemoteServices(this.fSelectedProvider);
        provider.setProject(project);
        return provider;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedProvider).getUIConnectionManager();
        return connectionManager;
    }

    private void handleConnectionSelected() {
        int selectionIndex = this.fConnectionCombo.getSelectionIndex();
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.fLocationText.setText(this.getDefaultPathDisplayString());
        this.update();
    }

    private void handleServicesSelected() {
        int selectionIndex = this.fProviderCombo.getSelectionIndex();
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
        this.populateConnectionCombo(this.fConnectionCombo);
        this.updateNewConnectionButtonEnabled(this.fNewConnectionButton);
        this.handleConnectionSelected();
        this.update();
    }

    public boolean isConfigComplete() {
        return this.getErrorMessage() == null;
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        connectionCombo.removeAll();
        IRemoteConnection[] connections = this.fSelectedProvider.getConnectionManager().getConnections();
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            ++k;
        }
        connectionCombo.select(0);
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(0);
    }

    private void update() {
        this.container.updateMessage();
        this.container.updateButtons();
    }

    private void updateNewConnectionButtonEnabled(Button button) {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        button.setEnabled(connectionManager != null);
    }

    public void setProjectName(String projectName) {
        this.fProjectName = projectName;
        this.fLocationText.setText(this.getDefaultPathDisplayString());
    }
}

