/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.contentassist;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ptp.internal.rdt.core.contentassist.CompletionType;
import org.eclipse.ptp.internal.rdt.core.contentassist.Proposal;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteProposalContextInformation;
import org.eclipse.ptp.internal.rdt.core.contentassist.Visibility;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.ui.contentassist.IContentAssistService;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompletionProposalAdapter
extends ParsingBasedProposalComputer {
    protected abstract IContentAssistService getService(IProject var1);

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        try {
            if (context instanceof CContentAssistInvocationContext) {
                CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
                return this.computeCompletionProposals(cContext, null, null);
            }
        }
        catch (Exception e) {
            UIPlugin.log(e);
        }
        return Collections.emptyList();
    }

    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode node, String prefix) throws CoreException {
        IProject project = context.getProject().getProject();
        IContentAssistService service = this.getService(project);
        if (service == null) {
            return Collections.emptyList();
        }
        ITranslationUnit unit = context.getTranslationUnit();
        Scope scope = new Scope(project);
        List<Proposal> rawProposals = service.computeCompletionProposals(scope, (ContentAssistInvocationContext)context, unit);
        List<ICompletionProposal> proposals = this.adaptProposals(context, rawProposals);
        return proposals;
    }

    private List<ICompletionProposal> adaptProposals(CContentAssistInvocationContext context, List<Proposal> proposals) {
        LinkedList<ICompletionProposal> result = new LinkedList<ICompletionProposal>();
        for (Proposal proposal : proposals) {
            ImageDescriptor descriptor;
            String replacement = proposal.getReplacementText();
            int offset = proposal.getReplacementOffset();
            int length = proposal.getReplacementLength();
            String display = proposal.getDisplayText();
            String id = proposal.getIdentifier();
            int relevance = proposal.getRelevance();
            ITextViewer viewer = context.getViewer();
            CompletionType type = proposal.getType();
            if (type.getVisibility() != Visibility.NotApplicable) {
                ASTAccessVisibility visibility;
                switch (type.getVisibility()) {
                    case Private: {
                        visibility = ASTAccessVisibility.PRIVATE;
                        break;
                    }
                    case Protected: {
                        visibility = ASTAccessVisibility.PROTECTED;
                        break;
                    }
                    default: {
                        visibility = ASTAccessVisibility.PUBLIC;
                    }
                }
                switch (type.getElementType()) {
                    case 72: {
                        descriptor = CElementImageProvider.getFieldImageDescriptor((ASTAccessVisibility)visibility);
                        break;
                    }
                    case 70: {
                        descriptor = CElementImageProvider.getMethodImageDescriptor((ASTAccessVisibility)visibility);
                        break;
                    }
                    default: {
                        descriptor = CElementImageProvider.getImageDescriptor((int)type.getElementType());
                        break;
                    }
                }
            } else {
                descriptor = CElementImageProvider.getImageDescriptor((int)type.getElementType());
            }
            Image image = CUIPlugin.getImageDescriptorRegistry().get(descriptor);
            CCompletionProposal completion = new CCompletionProposal(replacement, offset, length, image, display, id, relevance, viewer);
            completion.setCursorPosition(proposal.getCursorPosition());
            RemoteProposalContextInformation remoteContextInfo = proposal.getContextInformation();
            if (remoteContextInfo != null) {
                CProposalContextInformation contextInfo = new CProposalContextInformation(image, remoteContextInfo.getDisplayText(), remoteContextInfo.getDisplayArguments());
                contextInfo.setContextInformationPosition(remoteContextInfo.getContextInformationPosition());
                completion.setContextInformation((IContextInformation)contextInfo);
            }
            result.add((ICompletionProposal)completion);
        }
        return result;
    }
}

