/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.scannerinfo;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.ptp.internal.rdt.ui.scannerinfo.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RemoteIncludeDialog
extends Dialog {
    private Shell shell;
    private Button b_ok;
    private Button b_cancel;
    private Button b_browse;
    private Button b_vars;
    private Button b_add2confs;
    private Button b_add2langs;
    private Text text;
    private String pathText = null;
    private boolean result = false;
    private String directory = null;
    private boolean isAllLanguages = false;
    private boolean isAllConfigurations = false;
    private final ICConfigurationDescription config;
    private final boolean isEdit;
    private IHost fHost = null;
    private IRemoteConnection fRemoteConnection = null;
    private final SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String s;
            Widget pressed = e.widget;
            if (pressed.equals(RemoteIncludeDialog.this.b_ok)) {
                RemoteIncludeDialog.this.directory = RemoteIncludeDialog.this.text.getText();
                RemoteIncludeDialog.this.isAllConfigurations = RemoteIncludeDialog.this.b_add2confs.getSelection();
                RemoteIncludeDialog.this.isAllLanguages = RemoteIncludeDialog.this.b_add2langs.getSelection();
                RemoteIncludeDialog.this.result = true;
                RemoteIncludeDialog.this.shell.dispose();
            } else if (pressed.equals(RemoteIncludeDialog.this.b_cancel)) {
                RemoteIncludeDialog.this.result = false;
                RemoteIncludeDialog.this.shell.dispose();
            } else if (pressed.equals(RemoteIncludeDialog.this.b_browse)) {
                if (RemoteIncludeDialog.this.fHost != null) {
                    SystemRemoteFolderDialog folderDialog = new SystemRemoteFolderDialog(RemoteIncludeDialog.this.shell, Messages.RemoteIncludeDialog_select, RemoteIncludeDialog.this.fHost);
                    folderDialog.setShowNewConnectionPrompt(false);
                    folderDialog.open();
                    Object remoteObject = folderDialog.getSelectedObject();
                    if (remoteObject instanceof IRemoteFile) {
                        IRemoteFile folder = (IRemoteFile)remoteObject;
                        RemoteIncludeDialog.this.text.setText(folder.getCanonicalPath());
                    }
                } else {
                    IRemoteUIConnectionManager connMgr = RemoteIncludeDialog.this.getUIConnectionManager();
                    if (connMgr != null) {
                        IRemoteUIFileManager fileMgr;
                        connMgr.openConnectionWithProgress(RemoteIncludeDialog.this.shell, null, RemoteIncludeDialog.this.fRemoteConnection);
                        if (RemoteIncludeDialog.this.fRemoteConnection.isOpen() && (fileMgr = RemoteIncludeDialog.this.getUIFileManager()) != null) {
                            fileMgr.setConnection(RemoteIncludeDialog.this.fRemoteConnection);
                            String path = fileMgr.browseDirectory(RemoteIncludeDialog.this.shell, Messages.RemoteIncludeDialog_select, "", 0);
                            if (path != null) {
                                RemoteIncludeDialog.this.text.setText(path);
                            }
                        }
                    }
                }
            } else if (pressed.equals(RemoteIncludeDialog.this.b_vars) && (s = AbstractCPropertyTab.getVariableDialog((Shell)RemoteIncludeDialog.this.shell, (ICConfigurationDescription)RemoteIncludeDialog.this.config)) != null) {
                RemoteIncludeDialog.this.text.insert(s);
            }
        }
    };

    public RemoteIncludeDialog(Shell parent, String title, boolean isEdit, ICConfigurationDescription config) {
        super(parent);
        this.setText(title);
        this.isEdit = isEdit;
        this.config = config;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setText(this.getText());
        this.createDialogArea((Composite)this.shell);
        this.shell.pack();
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = this.shell.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + (r1.height - r2.height) / 2;
        this.shell.setBounds(x, y, r2.width, r2.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(parent, 0);
        l1.setText(Messages.RemoteIncludeDialog_directory);
        GridData gd = new GridData();
        l1.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.text = new Text(parent, 2052);
        gd = new GridData(768);
        this.text.setLayoutData((Object)gd);
        gd.widthHint = 300;
        this.text.setText(this.pathText == null ? "" : this.pathText);
        this.b_browse = new Button(parent, 8);
        this.b_browse.setText(Messages.RemoteIncludeDialog_browse);
        this.b_browse.addSelectionListener(this.listener);
        this.b_browse.setLayoutData((Object)new GridData(768));
        new Label(parent, 0);
        this.b_vars = new Button(parent, 8);
        this.b_vars.setText(Messages.RemoteIncludeDialog_vars);
        this.b_vars.addSelectionListener(this.listener);
        this.b_vars.setLayoutData((Object)new GridData(768));
        this.b_add2confs = new Button(parent, 32);
        this.b_add2confs.setText(Messages.RemoteIncludeDialog_configurations);
        this.b_add2confs.setVisible(!this.isEdit);
        gd = new GridData();
        this.b_add2confs.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.b_add2langs = new Button(parent, 32);
        this.b_add2langs.setText(Messages.RemoteIncludeDialog_languages);
        this.b_add2langs.setVisible(!this.isEdit);
        gd = new GridData();
        this.b_add2langs.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        this.b_ok = new Button(parent, 8);
        this.b_ok.setText(Messages.RemoteIncludeDialog_ok);
        this.b_ok.addSelectionListener(this.listener);
        gd = new GridData();
        this.b_ok.setLayoutData((Object)gd);
        gd.widthHint = 80;
        gd.horizontalAlignment = 0x1000008;
        this.b_cancel = new Button(parent, 8);
        this.b_cancel.setText(Messages.RemoteIncludeDialog_cancel);
        this.b_cancel.addSelectionListener(this.listener);
        gd = new GridData();
        this.b_cancel.setLayoutData((Object)gd);
        gd.widthHint = 80;
    }

    public void setPathText(String path) {
        this.pathText = path;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isAllLanguages() {
        return this.isAllLanguages;
    }

    public boolean isAllConfigurations() {
        return this.isAllConfigurations;
    }

    public void setHost(IHost host) {
        this.fHost = host;
    }

    public void setConnection(IRemoteConnection connection) {
        this.fRemoteConnection = connection;
    }

    private IRemoteUIFileManager getUIFileManager() {
        if (this.fRemoteConnection != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fRemoteConnection.getRemoteServices()).getUIFileManager();
        }
        return null;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fRemoteConnection != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fRemoteConnection.getRemoteServices()).getUIConnectionManager();
        }
        return null;
    }
}

