/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ptp.internal.rdt.core.search.RemoteLineSearchElement;

public class RemoteLineSearchElementAdapter {
    public static RemoteLineSearchElement[] createElements(IIndexFileLocation fileLocation, RemoteLineSearchElement.RemoteLineSearchElementMatch[] matches, IDocument document) {
        Arrays.sort(matches, RemoteLineSearchElement.MATCHES_COMPARATOR);
        ArrayList<RemoteLineSearchElement> result = new ArrayList<RemoteLineSearchElement>();
        ArrayList<RemoteLineSearchElement.RemoteLineSearchElementMatch> matchCollector = new ArrayList<RemoteLineSearchElement.RemoteLineSearchElementMatch>();
        int minOffset = 0;
        int lineNumber = 0;
        int lineOffset = 0;
        int lineLength = 0;
        int lineEndOffset = 0;
        try {
            RemoteLineSearchElement.RemoteLineSearchElementMatch[] remoteLineSearchElementMatchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteLineSearchElement.RemoteLineSearchElementMatch match = remoteLineSearchElementMatchArray[n2];
                int offset = match.getOffset();
                if (offset < lineEndOffset) {
                    if (offset < minOffset) {
                        matchCollector.add(match);
                        minOffset = offset + match.getLength();
                    }
                } else {
                    if (!matchCollector.isEmpty()) {
                        String content = document.get(lineOffset, lineLength);
                        RemoteLineSearchElement.RemoteLineSearchElementMatch[] lineMatches = matchCollector.toArray(new RemoteLineSearchElement.RemoteLineSearchElementMatch[matchCollector.size()]);
                        result.add(new RemoteLineSearchElement(fileLocation, lineMatches, lineNumber + 1, content, lineOffset));
                        matchCollector.clear();
                    }
                    lineNumber = document.getLineOfOffset(offset);
                    lineOffset = document.getLineOffset(lineNumber);
                    lineLength = document.getLineLength(lineNumber);
                    lineEndOffset = lineOffset + lineLength;
                    matchCollector.add(match);
                }
                ++n2;
            }
            if (!matchCollector.isEmpty()) {
                String content = document.get(lineOffset, lineLength);
                RemoteLineSearchElement.RemoteLineSearchElementMatch[] lineMatches = matchCollector.toArray(new RemoteLineSearchElement.RemoteLineSearchElementMatch[matchCollector.size()]);
                result.add(new RemoteLineSearchElement(fileLocation, lineMatches, lineNumber + 1, content, lineOffset));
                matchCollector.clear();
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.log((Throwable)e);
        }
        return result.toArray(new RemoteLineSearchElement[result.size()]);
    }
}

