/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ptp.internal.rdt.core.search.RemoteLineSearchElement;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchResult;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchTreeContentProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchViewPage;
import org.eclipse.ptp.internal.rdt.ui.search.TypeInfoSearchElement;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class RemoteSearchLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    protected final RemoteSearchViewPage fPage;
    private final TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(20);
    private final CUILabelProvider fCElementLabelProvider = new CUILabelProvider(0L, 2);

    public RemoteSearchLabelProvider(RemoteSearchViewPage page) {
        this.fPage = page;
    }

    public Image getImage(Object element) {
        if (element instanceof RemoteLineSearchElement) {
            RemoteLineSearchElement lineSearchElement = (RemoteLineSearchElement)element;
            ICElement enclosingElement = lineSearchElement.getMatches()[0].getEnclosingElement();
            if (!this.fPage.isShowEnclosingDefinitions() || enclosingElement == null) {
                return CDTSharedImages.getImage((String)"icons/obj16/searchm_obj.gif");
            }
            element = enclosingElement;
        }
        if (element instanceof TypeInfoSearchElement) {
            return this.fTypeInfoLabelProvider.getImage((Object)((TypeInfoSearchElement)((Object)element)).getTypeInfo());
        }
        if (element instanceof IIndexFileLocation || element instanceof URI) {
            return CDTSharedImages.getImage((String)"icons/obj16/include_obj.gif");
        }
        if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
            return CDTSharedImages.getImage((String)"icons/obj16/includes_container.gif");
        }
        if (element instanceof IPath) {
            return CDTSharedImages.getImage((String)"icons/obj16/hfolder_obj.gif");
        }
        if (element instanceof IStatus) {
            IStatus status = (IStatus)element;
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            switch (status.getSeverity()) {
                case 2: {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                case 4: {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            return sharedImages.getImage("IMG_OBJS_INFO_TSK");
        }
        return this.fCElementLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        IPath path;
        if (element instanceof RemoteLineSearchElement) {
            return element.toString();
        }
        if (element instanceof TypeInfoSearchElement) {
            return this.fTypeInfoLabelProvider.getText((Object)((TypeInfoSearchElement)((Object)element)).getTypeInfo());
        }
        if (element instanceof IPath) {
            return ((IPath)element).toString();
        }
        if (element instanceof IIndexFileLocation && (path = RemoteSearchTreeContentProvider.getAbsolutePath((IIndexFileLocation)element)) != null) {
            return path.lastSegment();
        }
        if (element instanceof URI) {
            return ((URI)element).toString();
        }
        if (element instanceof IStatus) {
            return ((IStatus)element).getMessage();
        }
        return this.fCElementLabelProvider.getText(element);
    }

    protected int getMatchCount(Object element) {
        if (element instanceof ITranslationUnit) {
            ITranslationUnit translationUnit = (ITranslationUnit)element;
            AbstractTextSearchResult searchResult = this.fPage.getInput();
            if (searchResult instanceof RemoteSearchResult) {
                RemoteSearchResult remoteSearchResult = (RemoteSearchResult)searchResult;
                IResource resource = translationUnit.getResource();
                if (resource instanceof IFile) {
                    return remoteSearchResult.computeContainedMatches(searchResult, (IFile)resource).length;
                }
            }
        }
        return this.fPage.getInput().getMatchCount(element);
    }

    public StyledString getStyledText(Object element) {
        if (!(element instanceof RemoteLineSearchElement)) {
            return new StyledString(this.getText(element));
        }
        RemoteLineSearchElement lineElement = (RemoteLineSearchElement)element;
        int lineOffset = lineElement.getOffset();
        String lineContent = lineElement.getContent();
        StyledString styled = new StyledString(lineContent);
        RemoteLineSearchElement.RemoteLineSearchElementMatch[] remoteLineSearchElementMatchArray = lineElement.getMatches();
        int n = remoteLineSearchElementMatchArray.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteLineSearchElement.RemoteLineSearchElementMatch match = remoteLineSearchElementMatchArray[n2];
            int offset = Math.max(0, match.getOffset() - lineOffset);
            int length = Math.min(match.getLength(), lineContent.length() - offset);
            StyledString.Styler style = match.isWriteAccess() ? ColoringLabelProvider.HIGHLIGHT_WRITE_STYLE : ColoringLabelProvider.HIGHLIGHT_STYLE;
            styled.setStyle(offset, length, style);
            ++n2;
        }
        return styled;
    }
}

