/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search.actions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.navigation.INavigationService;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.ui.search.actions.SelectionParseAction;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

class OpenDeclarationsJob
extends Job {
    private final SelectionParseAction fAction;
    private final ITranslationUnit fTranslationUnit;
    private final ITextSelection fTextSelection;
    private final String fSelectedText;
    private CEditor fEditor;

    OpenDeclarationsJob(SelectionParseAction action, ITranslationUnit editorInput, ITextSelection textSelection, String text, CEditor editor) {
        super(CEditorMessages.OpenDeclarations_dialog_title);
        this.fAction = action;
        this.fTranslationUnit = editorInput;
        this.fTextSelection = textSelection;
        this.fSelectedText = text;
        this.fEditor = editor;
    }

    private INavigationService getNavigationService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (!(serviceProvider instanceof IIndexServiceProvider2)) {
            return null;
        }
        INavigationService service = ((IIndexServiceProvider2)serviceProvider).getNavigationService();
        return service;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            return this.performNavigation(monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    IStatus performNavigation(IProgressMonitor monitor) throws CoreException {
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        if (workingCopy == null) {
            return Status.CANCEL_STATUS;
        }
        ICProject project = workingCopy.getCProject();
        if (this.fEditor.isDirty()) {
            String contents = this.fEditor.getViewer().getDocument().get();
            workingCopy = new WorkingCopy(null, (ITranslationUnit)workingCopy, contents);
        } else {
            workingCopy = (ITranslationUnit)ModelAdapter.adaptElement(null, (ICElement)workingCopy, (int)0, (boolean)true);
        }
        Scope scope = new Scope(workingCopy.getCProject().getProject());
        int selectionStart = this.fTextSelection.getOffset();
        int selectionLength = this.fTextSelection.getLength();
        INavigationService service = this.getNavigationService(workingCopy.getCProject().getProject());
        OpenDeclarationResult result = service.openDeclaration(scope, (ITranslationUnit)workingCopy, this.fSelectedText, selectionStart, selectionLength, monitor);
        if (result == null) {
            return Status.OK_STATUS;
        }
        switch (result.getResultType()) {
            case RESULT_NAMES: {
                IName[] names = (IName[])result.getResult();
                this.navigateOneLocation(names, project);
                break;
            }
            case RESULT_C_ELEMENTS: {
                ICElement[] elements = (ICElement[])result.getResult();
                this.navigateCElements(elements, project);
                break;
            }
            case RESULT_INCLUDE_PATH: {
                String path = (String)result.getResult();
                this.open(path, (ICElement)project);
                break;
            }
            case RESULT_NAME: {
                IName name = (IName)result.getResult();
                this.navigateToName(name, project);
                break;
            }
            case RESULT_LOCATION: {
                IASTFileLocation location = (IASTFileLocation)result.getResult();
                this.navigateToLocation(location, project);
                break;
            }
            case FAILURE_SYMBOL_LOOKUP: {
                String symbol = (String)result.getResult();
                this.fAction.reportSymbolLookupFailure(symbol);
                break;
            }
            case FAILURE_INCLUDE_LOOKUP: {
                String includedPath = (String)result.getResult();
                this.fAction.reportIncludeLookupFailure(includedPath);
                break;
            }
            default: {
                this.fAction.reportSelectionMatchFailure();
            }
        }
        return Status.OK_STATUS;
    }

    private URI replacePath(URI u, String path) {
        return EFSExtensionManager.getDefault().createNewURIFromPath(u, path);
    }

    private void open(String path, ICElement element) {
        this.open(path, element, -1, -1);
    }

    private void open(String path, ICElement element, int offset, int length) {
        URI uri = this.replacePath(element.getLocationURI(), path);
        if (uri == null) {
            return;
        }
        this.open(uri, element, offset, length);
    }

    private void open(final URI uri, final ICElement element, final int offset, final int length) {
        this.runInUIThread(new Runnable(){

            public void run() {
                try {
                    OpenDeclarationsJob.this.fAction.clearStatusLine();
                    IEditorPart editor = EditorUtility.openInEditor((URI)uri, (ICElement)element);
                    if (editor instanceof ITextEditor) {
                        ITextEditor textEditor = (ITextEditor)editor;
                        if (offset >= 0 && length >= 0) {
                            textEditor.selectAndReveal(offset, length);
                        }
                    } else {
                        OpenDeclarationsJob.this.reportSourceFileOpenFailure(uri.toString());
                    }
                }
                catch (CoreException e) {
                    RDTLog.logError((Throwable)e);
                }
            }
        });
    }

    private void navigateCElements(final ICElement[] elements, final ICProject project) {
        ICElement[] uniqueElements;
        if (elements == null || elements.length == 0) {
            return;
        }
        if (elements.length < 2) {
            uniqueElements = elements;
        } else {
            HashSet<String> sigs = new HashSet<String>();
            sigs.add(null);
            ArrayList<ICElement> uniqueElementsList = new ArrayList<ICElement>();
            ICElement[] iCElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement elem = iCElementArray[n2];
                if (sigs.add(this.getLocationSignature((ISourceReference)elem))) {
                    uniqueElementsList.add(elem);
                }
                ++n2;
            }
            uniqueElements = uniqueElementsList.toArray(new ICElement[uniqueElementsList.size()]);
        }
        this.runInUIThread(new Runnable(){

            public void run() {
                ICElement target = uniqueElements.length == 1 ? uniqueElements[0] : OpenActionUtil.selectCElement((ICElement[])elements, (Shell)OpenDeclarationsJob.this.fAction.getSite().getShell(), (String)CEditorMessages.OpenDeclarationsAction_dialog_title, (String)CEditorMessages.OpenDeclarationsAction_selectMessage, (long)2182096929L, (int)0);
                if (target instanceof ISourceReference) {
                    try {
                        ISourceRange sourceRange = ((ISourceReference)target).getSourceRange();
                        URI uri = OpenDeclarationsJob.this.replacePath(target.getLocationURI(), target.getPath().toString());
                        OpenDeclarationsJob.this.open(uri, (ICElement)project, sourceRange.getIdStartPos(), sourceRange.getIdLength());
                    }
                    catch (CoreException e) {
                        RDTLog.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private String getLocationSignature(ISourceReference elem) {
        ITranslationUnit tu = elem.getTranslationUnit();
        try {
            ISourceRange sourceRange = elem.getSourceRange();
            if (tu != null && sourceRange != null) {
                return String.valueOf(tu.getPath().toString()) + '/' + sourceRange.getIdStartPos() + '/' + sourceRange.getIdLength();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
        return null;
    }

    protected void reportSourceFileOpenFailure(String path) {
        this.fAction.showStatusLineMessage(MessageFormat.format(CSearchMessages.SelectionParseAction_FileOpenFailure_format, path));
    }

    private void navigateOneLocation(IName[] declNames, ICProject project) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            IASTFileLocation fileloc = name.getFileLocation();
            if (fileloc != null) {
                String filePath = fileloc.getFileName();
                int offset = fileloc.getNodeOffset();
                int length = fileloc.getNodeLength();
                this.open(filePath, (ICElement)project, offset, length);
                return;
            }
            ++n2;
        }
    }

    private void navigateToName(IName name, ICProject project) {
        this.navigateToLocation(name.getFileLocation(), project);
    }

    private void navigateToLocation(IASTFileLocation fileloc, ICProject project) {
        if (fileloc != null) {
            String filePath = fileloc.getFileName();
            int offset = fileloc.getNodeOffset();
            int length = fileloc.getNodeLength();
            this.open(filePath, (ICElement)project, offset, length);
        }
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }
}

