/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.internal.rdt.ui.RSEUtils;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.remotemake.RemoteMakeBuilder;
import org.eclipse.ptp.rdt.core.resources.RemoteMakeNature;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.widgets.ServiceProviderConfigurationWidget;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConvertToRemoteWizardPage
extends ConvertProjectWizardPage {
    protected static final String WZ_TITLE = "WizardProjectConversion.title";
    protected static final String WZ_DESC = "WizardProjectConversion.description";
    protected ServiceProviderConfigurationWidget fServiceModelWidget;
    protected Group remoteServices;
    protected Map<IProject, IServiceConfiguration> projectConfigs = new HashMap<IProject, IServiceConfiguration>();

    public ConvertToRemoteWizardPage(String pageName) {
        super(pageName);
    }

    protected String getWzTitleResource() {
        return Messages.getString(WZ_TITLE);
    }

    protected String getWzDescriptionResource() {
        return Messages.getString(WZ_DESC);
    }

    public boolean isCandidate(IProject project) {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        boolean d = false;
        a = !project.isHidden();
        try {
            try {
                ServiceModelManager.getInstance().getConfigurations(project);
            }
            catch (ProjectNotConfiguredException projectNotConfiguredException) {
                b = true;
            }
            c = !project.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature");
            IHost host = RSEUtils.getConnection(project.getLocationURI());
            if (host != null) {
                d = !host.getSystemType().isLocal();
            } else {
                IFileStore fileStore = EFS.getStore((URI)project.getLocationURI());
                if (fileStore != null && !(fileStore instanceof LocalFile)) {
                    d = true;
                }
            }
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
        }
        return a && b && c && d;
    }

    public void convertProject(IProject project, String bsId, IProgressMonitor monitor) throws CoreException {
        this.convertProject(project, monitor);
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        this.convertProject(project, monitor);
    }

    protected void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.getString("WizardProjectConversion.monitor.convertingToRemoteProject"), 3);
        try {
            RemoteNature.addRemoteNature((IProject)project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            RemoteMakeNature.updateProjectDescription((IProject)project, (String)RemoteMakeBuilder.BUILDER_ID, (IProgressMonitor)monitor);
            this.configureServicesForRemoteProject(project);
        }
        finally {
            monitor.done();
        }
    }

    protected void addToMainPage(Composite container) {
        this.remoteServices = new Group(container, 4);
        this.remoteServices.setText(Messages.getString("WizardProjectConversion.servicesTableLabel"));
        this.remoteServices.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 350;
        this.remoteServices.setLayoutData((Object)data);
        this.fServiceModelWidget = new ServiceProviderConfigurationWidget((Composite)this.remoteServices, 0);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IProject project = (IProject)((IStructuredSelection)e.getSelection()).getFirstElement();
                if (project != null) {
                    ConvertToRemoteWizardPage.this.changeProject(project);
                }
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                IProject project = (IProject)e.getElement();
                if (e.getChecked() && project != null) {
                    ConvertToRemoteWizardPage.this.changeProject(project);
                }
            }
        });
        Shell shell = this.getContainer().getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ptp.rdt.ui.converting_to_remote_project_context");
    }

    public void doRun(IProgressMonitor monitor, String projectID, String bsId) throws CoreException {
        monitor.beginTask(Messages.getString("ConvertToRemoteWizardPage.0"), 2);
        this.fServiceModelWidget.applyChangesToConfiguration();
        super.doRun((IProgressMonitor)new SubProgressMonitor(monitor, 1), projectID, bsId);
        try {
            try {
                ServiceModelManager.getInstance().saveModelConfiguration();
            }
            catch (IOException e) {
                UIPlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IServiceConfiguration getConfig(IProject project) {
        IServiceConfiguration config = this.projectConfigs.get(project);
        IHost host = RSEUtils.getConnection(project.getLocationURI());
        if (config == null && host != null) {
            config = ServiceModelManager.getInstance().newServiceConfiguration(project.getName());
            this.projectConfigs.put(project, config);
        }
        return config;
    }

    protected void changeProject(IProject project) {
        IServiceConfiguration config = this.getConfig(project);
        this.fServiceModelWidget.applyChangesToConfiguration();
        this.fServiceModelWidget.setServiceConfiguration(config);
        this.remoteServices.setText(MessageFormat.format(Messages.getString("WizardProjectConversion.servicesTableForProjectLabel"), project.getName()));
    }

    protected void configureServicesForRemoteProject(IProject project) {
        ServiceModelManager.getInstance().addConfiguration(project, this.getConfig(project));
    }
}

