/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileSystem;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsServices;
import org.eclipse.ptp.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;

public class RemoteToolsConnectionManager
implements IRemoteConnectionManager,
ITargetEventListener {
    private final IRemoteServices fRemoteServices;
    private final TargetTypeElement fRemoteHost;
    private final Map<String, IRemoteConnection> fConnections = new HashMap<String, IRemoteConnection>();

    public RemoteToolsConnectionManager(IRemoteServices services) {
        this.fRemoteServices = services;
        this.fRemoteHost = RemoteToolsServices.getTargetTypeElement();
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        targetMgr.addModelEventListener((ITargetEventListener)this);
        this.refreshConnections();
    }

    public IRemoteConnection getConnection(String name) {
        this.refreshConnections();
        return this.fConnections.get(name);
    }

    public IRemoteConnection getConnection(URI uri) {
        String connName = RemoteToolsFileSystem.getConnectionNameFor(uri);
        if (connName != null) {
            return this.getConnection(connName);
        }
        return null;
    }

    public IRemoteConnection[] getConnections() {
        this.refreshConnections();
        return this.fConnections.values().toArray(new IRemoteConnection[this.fConnections.size()]);
    }

    public void handleStateChangeEvent(int event, ITargetElement element) {
        IRemoteConnection conn = this.fConnections.get(element.getName());
        if (conn != null) {
            switch (event) {
                case 2: {
                    ((RemoteToolsConnection)conn).fireConnectionChangeEvent(conn, 2);
                    break;
                }
                case 1: {
                    ((RemoteToolsConnection)conn).fireConnectionChangeEvent(conn, 1);
                    break;
                }
            }
        }
    }

    public IRemoteConnection newConnection(String name) throws RemoteConnectionException {
        String id = EnvironmentPlugin.getDefault().getEnvironmentUniqueID();
        TargetElement element = new TargetElement(this.fRemoteHost, name, id);
        this.fRemoteHost.addElement(element);
        return this.createConnection((ITargetElement)element);
    }

    public void removeConnection(IRemoteConnection conn) throws RemoteConnectionException {
        if (!(conn instanceof RemoteToolsConnection)) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnectionManager_invalidConnectionType);
        }
        if (conn.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnectionManager_cannotRemoveOpenConnection);
        }
        this.fConnections.remove(conn);
        ((RemoteToolsConnection)conn).dispose();
    }

    private IRemoteConnection createConnection(ITargetElement element) throws RemoteConnectionException {
        try {
            return new RemoteToolsConnection(element.getName(), element, this.fRemoteServices);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private void refreshConnections() {
        if (this.fRemoteHost != null) {
            HashMap<String, IRemoteConnection> newConns = new HashMap<String, IRemoteConnection>();
            for (Object obj : this.fRemoteHost.getElements()) {
                ITargetElement element = (ITargetElement)obj;
                IRemoteConnection conn = this.fConnections.get(element.getName());
                if (conn == null) {
                    try {
                        conn = this.createConnection(element);
                    }
                    catch (RemoteConnectionException remoteConnectionException) {}
                }
                newConns.put(element.getName(), conn);
            }
            this.fConnections.clear();
            this.fConnections.putAll(newConns);
        }
    }
}

