/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsAdapterCorePlugin;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnectionManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileSystem;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsServices;
import org.eclipse.ptp.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class RemoteToolsFileStore
extends FileStore {
    private static Map<String, RemoteToolsFileStore> instanceMap = new HashMap<String, RemoteToolsFileStore>();
    private final String fConnectionName;
    private final IPath fRemotePath;
    private IRemoteItem fRemoteItem = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteToolsFileStore getInstance(URI uri) {
        Map<String, RemoteToolsFileStore> map = instanceMap;
        synchronized (map) {
            String name;
            RemoteToolsFileStore store = instanceMap.get(uri.toString());
            if (store == null && (name = RemoteToolsFileSystem.getConnectionNameFor(uri)) != null) {
                String path = uri.getPath();
                store = new RemoteToolsFileStore(name, path);
                instanceMap.put(uri.toString(), store);
            }
            return store;
        }
    }

    public RemoteToolsFileStore(String connName, String path) {
        this.fConnectionName = connName;
        this.fRemotePath = new Path(path);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem[] items;
        try {
            items = this.getExecutionManager(monitor).getRemoteFileTools().listItems(this.fRemotePath.toString(), monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getMessage(), null));
        }
        FileInfo[] result = new FileInfo[items.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.convertRemoteItemToFileInfo(items[i], this.getNameFromPath((IPath)new Path(items[i].getPath())));
            ++i;
        }
        return result;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem[] items;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            items = this.getExecutionManager(monitor).getRemoteFileTools().listItems(this.fRemotePath.toString(), monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getMessage(), null));
        }
        String[] names = new String[items.length];
        int i = 0;
        while (i < items.length) {
            Path path = new Path(items[i].getPath());
            names[i] = path.lastSegment();
            ++i;
        }
        return names;
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem item;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((item = this.getRemoteItem(monitor)).exists()) {
            try {
                this.cacheRemoteItem(null);
                if (item.isDirectory()) {
                    this.getExecutionManager(monitor).getRemoteFileTools().removeDirectory(this.fRemotePath.toString(), monitor);
                } else {
                    this.getExecutionManager(monitor).getRemoteFileTools().removeFile(this.fRemotePath.toString(), monitor);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_0, (Throwable)e));
            }
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRemoteItem item = this.getRemoteItem(monitor);
        return this.convertRemoteItemToFileInfo(item, this.getName());
    }

    public IFileStore getChild(String name) {
        URI uri = RemoteToolsFileSystem.getURIFor(this.fConnectionName, this.fRemotePath.append(name).toString());
        return RemoteToolsFileStore.getInstance(uri);
    }

    public String getName() {
        return this.getNameFromPath(this.fRemotePath);
    }

    public IFileStore getParent() {
        if (this.fRemotePath.isRoot()) {
            return null;
        }
        String parentPath = this.fRemotePath.toString();
        if (this.fRemotePath.segmentCount() > 0) {
            parentPath = this.fRemotePath.removeLastSegments(1).toString();
        }
        return RemoteToolsFileStore.getInstance(RemoteToolsFileSystem.getURIFor(this.fConnectionName, parentPath));
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem item;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(item = this.getRemoteItem(monitor)).exists()) {
            IFileStore parent;
            if ((options & 4) == 4 && (parent = this.getParent()) != null && !parent.fetchInfo(0, monitor).exists()) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 272, Messages.RemoteToolsFileStore_1, null));
            }
            try {
                this.getExecutionManager(monitor).getRemoteFileTools().createDirectory(this.fRemotePath.toString(), monitor);
                this.cacheRemoteItem(null);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_2, (Throwable)e));
            }
        } else if (!item.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 276, Messages.RemoteToolsFileStore_13, null));
        }
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem item;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(item = this.getRemoteItem(monitor)).exists()) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 271, Messages.RemoteToolsFileStore_14, null));
        }
        if (item.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 276, Messages.RemoteToolsFileStore_3, null));
        }
        try {
            return this.getExecutionManager(monitor).getRemoteFileTools().getInputStream(item.getPath(), monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_4, (Throwable)e));
        }
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        IRemoteItem item;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((item = this.getRemoteItem(monitor)).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 276, Messages.RemoteToolsFileStore_3, null));
        }
        try {
            options = (options & 1) != 0 ? 1 : 0;
            this.cacheRemoteItem(null);
            return this.getExecutionManager(monitor).getRemoteFileTools().getOutputStream(item.getPath(), options, monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_6, (Throwable)e));
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IRemoteItem item = this.getRemoteItem(monitor);
        boolean modified = false;
        if ((options & 0x400) != 0) {
            boolean writeable = !info.getAttribute(2);
            item.setWriteable(writeable);
            boolean executable = info.getAttribute(4);
            item.setExecutable(executable);
            modified = true;
        }
        if ((options & 0x800) != 0) {
            long modtime = info.getLastModified();
            item.setModificationTime(modtime);
            modified = true;
        }
        if (modified) {
            try {
                item.commitAttributes(monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getMessage(), (Throwable)e));
            }
        }
    }

    public URI toURI() {
        return RemoteToolsFileSystem.getURIFor(this.fConnectionName, this.fRemotePath.toString());
    }

    private void cacheRemoteItem(IRemoteItem item) {
        this.fRemoteItem = item;
    }

    private IFileInfo convertRemoteItemToFileInfo(IRemoteItem item, String name) {
        FileInfo info = new FileInfo(name);
        if (!item.exists()) {
            info.setExists(false);
            return info;
        }
        info.setExists(true);
        info.setLastModified(item.getModificationTime());
        info.setDirectory(item.isDirectory());
        info.setAttribute(2, !item.isWritable());
        info.setAttribute(4, item.isExecutable());
        info.setLength(item.getSize());
        return info;
    }

    private IRemoteExecutionManager getExecutionManager(IProgressMonitor monitor) throws CoreException {
        RemoteToolsConnectionManager connMgr;
        RemoteToolsServices services = RemoteToolsServices.getInstance();
        if (!services.isInitialized()) {
            services.initialize();
            if (!services.isInitialized()) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_5, null));
            }
        }
        if ((connMgr = (RemoteToolsConnectionManager)services.getConnectionManager()) == null) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_7, null));
        }
        RemoteToolsConnection conn = (RemoteToolsConnection)connMgr.getConnection(this.fConnectionName);
        if (conn == null) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, NLS.bind((String)Messages.RemoteToolsFileStore_8, (Object)this.fConnectionName), null));
        }
        if (!conn.isOpen()) {
            try {
                conn.open(monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getLocalizedMessage(), (Throwable)e));
            }
            if (monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, Messages.RemoteToolsFileStore_12, null));
            }
            if (!conn.isOpen()) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, NLS.bind((String)Messages.RemoteToolsFileStore_10, (Object)this.fConnectionName), null));
            }
        }
        try {
            return conn.createExecutionManager();
        }
        catch (RemoteConnectionException e) {
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private String getNameFromPath(IPath path) {
        if (path.isRoot()) {
            return path.toString();
        }
        return path.lastSegment();
    }

    private IRemoteItem getRemoteItem(IProgressMonitor monitor) throws CoreException {
        IRemoteExecutionManager mgr = this.getExecutionManager(monitor);
        if (this.fRemoteItem == null) {
            try {
                IRemoteFileTools tools = mgr.getRemoteFileTools();
                this.cacheRemoteItem(tools.getItem(this.fRemotePath.toString()));
            }
            catch (RemoteConnectionException e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getLocalizedMessage(), (Throwable)e));
            }
            catch (RemoteOperationException e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getLocalizedMessage(), (Throwable)e));
            }
            catch (CancelException e) {
                throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getLocalizedMessage(), (Throwable)e));
            }
        }
        try {
            this.fRemoteItem.refreshAttributes(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, RemoteToolsAdapterCorePlugin.getDefault().getBundle().getSymbolicName(), 566, e.getLocalizedMessage(), (Throwable)e));
        }
        return this.fRemoteItem;
    }
}

