/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.dialogs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.internal.ui.RemoteUIImages;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.dialogs.DeferredFileStore;
import org.eclipse.ptp.remote.ui.dialogs.RemoteContentProvider;
import org.eclipse.ptp.remote.ui.dialogs.RemoteResourceComparator;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class RemoteResourceBrowser
extends Dialog {
    public static final String EMPTY_STRING = "";
    public static final int FILE_BROWSER = 1;
    public static final int DIRECTORY_BROWSER = 2;
    public static final int SINGLE = 1;
    public static final int MULTI = 2;
    private static final int widthHint = 300;
    private static final int heightHint = 300;
    private Tree tree = null;
    private TreeViewer treeViewer = null;
    private Text remotePathText = null;
    private Button okButton = null;
    private Combo connectionCombo = null;
    private Button newButton = null;
    private Button upButton = null;
    private int browserType;
    private String dialogTitle;
    private String dialogLabel;
    private boolean showConnections = false;
    private String remotePath = "";
    private String[] remotePaths;
    private String fInitialPath = null;
    private IPath fRootPath = null;
    private IRemoteServices fServices = null;
    private IRemoteFileManager fFileMgr = null;
    private IRemoteConnection fConnection = null;
    private IRemoteConnectionManager fConnMgr = null;
    private IRemoteUIConnectionManager fUIConnMgr = null;
    private int optionFlags = 1;

    public RemoteResourceBrowser(IRemoteServices services, IRemoteConnection conn, Shell parent, int flags) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.fServices = services;
        this.fConnection = conn;
        this.optionFlags = flags;
        if (conn == null) {
            this.showConnections = true;
        }
        this.fConnMgr = services.getConnectionManager();
        this.fUIConnMgr = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(services).getUIConnectionManager();
        this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        this.setType(3);
    }

    public IRemoteConnection getConnection() {
        return this.fConnection;
    }

    public String getPath() {
        if (this.remotePath.equals(EMPTY_STRING)) {
            return null;
        }
        return this.remotePath;
    }

    public String[] getPaths() {
        return this.remotePaths;
    }

    public void setInitialPath(String path) {
        this.fInitialPath = path;
    }

    public void setTitle(String title) {
        Shell shell;
        this.dialogTitle = title;
        if (this.dialogTitle == null) {
            this.dialogTitle = EMPTY_STRING;
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setText(this.dialogTitle);
        }
    }

    public void setType(int type) {
        this.browserType = type;
        if (type == 1) {
            this.dialogLabel = Messages.RemoteResourceBrowser_fileLabel;
            this.setTitle(Messages.RemoteResourceBrowser_fileTitle);
        } else if (type == 2) {
            this.dialogLabel = Messages.RemoteResourceBrowser_directoryLabel;
            this.setTitle(Messages.RemoteResourceBrowser_directoryTitle);
        } else {
            this.dialogLabel = Messages.RemoteResourceBrowser_resourceLabel;
            this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        }
    }

    public void showConnections(boolean enable) {
        this.showConnections = enable;
    }

    private boolean changeInput(IRemoteConnection conn) {
        if (conn == null) {
            return false;
        }
        this.fUIConnMgr.openConnectionWithProgress(this.getShell(), null, conn);
        if (!conn.isOpen()) {
            return false;
        }
        this.fFileMgr = this.fServices.getFileManager(conn);
        if (this.fFileMgr != null) {
            String cwd = conn.getWorkingDirectory();
            IPath initial = this.findInitialPath(cwd, this.fInitialPath);
            this.setRoot(initial.toString());
            this.fConnection = conn;
            return true;
        }
        return false;
    }

    private void connectionSelected() {
        IRemoteConnection conn;
        int i = this.connectionCombo.getSelectionIndex();
        if (i >= 0 && !this.changeInput(conn = this.fConnMgr.getConnection(this.connectionCombo.getItem(i)))) {
            if (this.fConnection == null) {
                this.connectionCombo.deselectAll();
            } else {
                i = 0;
                while (i < this.connectionCombo.getItemCount()) {
                    if (this.fConnection.equals(this.connectionCombo.getItem(i))) {
                        this.connectionCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void createConnectionChooser(Composite comp) {
        Composite connComp = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        connComp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        connComp.setLayoutData((Object)gd);
        Label label = new Label(connComp, 0);
        label.setText(Messages.RemoteResourceBrowser_connectonLabel);
        gd = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(connComp, 8);
        gd = new GridData(4, 0x1000000, true, false);
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() == RemoteResourceBrowser.this.connectionCombo) {
                    RemoteResourceBrowser.this.connectionSelected();
                }
            }
        });
        this.newButton = new Button(connComp, 8);
        this.newButton.setText(Messages.RemoteResourceBrowser_newConnection);
        gd = new GridData(1, 0x1000000, false, false);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IRemoteConnection conn;
                if (RemoteResourceBrowser.this.fUIConnMgr != null && (conn = RemoteResourceBrowser.this.fUIConnMgr.newConnection(RemoteResourceBrowser.this.getShell())) != null) {
                    RemoteResourceBrowser.this.updateConnectionCombo(conn);
                }
            }
        });
    }

    private IPath findInitialPath(String cwd, String initialPath) {
        if (initialPath != null) {
            Path path = new Path(initialPath);
            if (!path.isAbsolute()) {
                path = new Path(cwd).append((IPath)path);
            }
            if (this.fFileMgr.getResource(path.toString()).fetchInfo().exists()) {
                return path;
            }
        }
        return new Path(cwd);
    }

    private void setRoot(String path) {
        if (this.fFileMgr != null) {
            IFileStore root = this.fFileMgr.getResource(path);
            this.treeViewer.setInput((Object)new DeferredFileStore(root));
            this.remotePathText.setText(path);
            this.remotePathText.setSelection(this.remotePathText.getText().length());
            this.fRootPath = new Path(path);
        }
    }

    private void updateConnectionCombo(IRemoteConnection conn) {
        IRemoteConnectionManager mgr = this.fServices.getConnectionManager();
        IRemoteConnection[] conns = mgr.getConnections();
        if (conns.length > 0) {
            Arrays.sort(conns, new Comparator<IRemoteConnection>(){

                @Override
                public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
        }
        this.connectionCombo.removeAll();
        int selected = -1;
        int i = 0;
        while (i < conns.length) {
            this.connectionCombo.add(conns[i].getName());
            if (conn != null && conn.equals(conns[i])) {
                selected = i;
            }
            ++i;
        }
        if (selected < 0) {
            this.connectionCombo.deselectAll();
        } else {
            this.connectionCombo.select(selected);
        }
        this.connectionSelected();
    }

    private void updateDialog() {
        if (this.remotePathText != null && this.okButton != null) {
            if (this.remotePathText.getText().equals(EMPTY_STRING)) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
        if (this.remotePathText != null && this.upButton != null) {
            boolean enabled = false;
            String pathText = this.remotePathText.getText();
            if (!pathText.equals(EMPTY_STRING)) {
                Path path = new Path(pathText);
                enabled = !path.isRoot();
            }
            this.upButton.setEnabled(enabled);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.dialogTitle);
        this.remotePathText.setText(this.remotePath);
        if (this.showConnections) {
            this.updateConnectionCombo(this.fConnection);
        } else {
            this.changeInput(this.fConnection);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Composite dialogComp = new Composite(main, 0);
        dialogComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogComp.setLayout((Layout)layout);
        Label label = new Label(dialogComp, 0);
        label.setText(this.dialogLabel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (this.showConnections) {
            this.createConnectionChooser(dialogComp);
        }
        this.remotePathText = new Text(dialogComp, 2052);
        this.remotePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteResourceBrowser.this.remotePath = RemoteResourceBrowser.this.remotePathText.getText();
                RemoteResourceBrowser.this.updateDialog();
            }
        });
        this.remotePathText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RemoteResourceBrowser.this.getShell().setDefaultButton(null);
            }

            public void focusLost(FocusEvent e) {
                RemoteResourceBrowser.this.getShell().setDefaultButton(RemoteResourceBrowser.this.okButton);
            }
        });
        this.remotePathText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RemoteResourceBrowser.this.remotePathText.setSelection(RemoteResourceBrowser.this.remotePathText.getText().length());
                RemoteResourceBrowser.this.setRoot(RemoteResourceBrowser.this.remotePathText.getText());
            }
        });
        gd = new GridData(768);
        gd.widthHint = 300;
        this.remotePathText.setLayoutData((Object)gd);
        this.upButton = new Button(dialogComp, 0x800008);
        this.upButton.setImage(RemoteUIImages.get("org.eclipse.ptp.remote.ui.elcl16.up_nav.gif"));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RemoteResourceBrowser.this.fRootPath.isRoot()) {
                    RemoteResourceBrowser.this.setRoot(RemoteResourceBrowser.this.fRootPath.removeLastSegments(1).toOSString());
                }
            }
        });
        this.tree = (this.optionFlags & 2) == 2 ? new Tree(main, 2050) : new Tree(main, 2052);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = Math.max(main.getParent().getSize().y, 300);
        this.tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object element = ss.getFirstElement();
                    if (element instanceof DeferredFileStore) {
                        DeferredFileStore dfs = (DeferredFileStore)element;
                        RemoteResourceBrowser.this.remotePathText.setText(dfs.getFileStore().toURI().getPath());
                    }
                    Vector<String> selectedPaths = new Vector<String>(ss.size());
                    Object[] objectArray = ss.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object currentSelection = objectArray[n2];
                        if (currentSelection instanceof DeferredFileStore) {
                            selectedPaths.add(((DeferredFileStore)currentSelection).getFileStore().toURI().getPath());
                        }
                        ++n2;
                    }
                    RemoteResourceBrowser.this.remotePaths = selectedPaths.toArray(new String[0]);
                }
            }
        });
        this.treeViewer.setComparator((ViewerComparator)new RemoteResourceComparator());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object o = s.getFirstElement();
                if (RemoteResourceBrowser.this.treeViewer.isExpandable(o)) {
                    RemoteResourceBrowser.this.treeViewer.setExpandedState(o, !RemoteResourceBrowser.this.treeViewer.getExpandedState(o));
                }
            }
        });
        if (this.browserType == 2) {
            this.treeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof DeferredFileStore) {
                        return ((DeferredFileStore)element).isContainer();
                    }
                    return element instanceof PendingUpdateAdapter;
                }
            });
        }
        this.updateDialog();
        return main;
    }
}

