/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.IAuthInfo;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteOperation;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.RemoteTunnel;
import org.eclipse.ptp.remotetools.internal.core.ConnectionProperties;
import org.eclipse.ptp.remotetools.internal.ssh.CipherTypes;
import org.eclipse.ptp.remotetools.internal.ssh.ConnectionLocks;
import org.eclipse.ptp.remotetools.internal.ssh.ControlChannel;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionObserver;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;
import org.eclipse.ptp.remotetools.internal.ssh.RemotePortForwardingPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
implements IRemoteConnection {
    private final IJSchService jsch = RemotetoolsPlugin.getDefault().getJSchService();
    private Session defaultSession;
    private String fUsername;
    private String fHostname;
    private SSHUserInfo fUserInfo;
    private int fPort;
    private int fTimeout;
    private String fCipherType;
    private IRemoteExecutionManager executionManager = null;
    private final Set<RemoteTunnel> tunnels = Collections.synchronizedSet(new HashSet());
    private static final int SFTP_POOLSIZE = 3;
    private final ArrayBlockingQueue<ChannelSftp> sftpChannelPool = new ArrayBlockingQueue(3);
    private final Hashtable<Integer, KillableExecution> activeProcessTable = new Hashtable();
    private int nextInternalPID;
    private ControlChannel controlChannel;
    private ExecutionObserver executionObserver;
    private final List<ConnectionSlot> connectionPool = Collections.synchronizedList(new ArrayList());
    private final Map<Channel, ConnectionSlot> channelToConnectioPool = Collections.synchronizedMap(new HashMap());
    protected ConnectionLocks connectionLocks;
    private RemotePortForwardingPool forwardingPool;

    @Override
    public synchronized void connect(IAuthInfo authInfo, String hostname, int port, String cipherType, int timeout, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.nextInternalPID = 0;
            this.fUsername = authInfo.getUsername();
            this.fUserInfo = new SSHUserInfo(authInfo);
            if (!authInfo.isPasswordAuth()) {
                try {
                    this.jsch.getJSch().addIdentity(authInfo.getKeyPath());
                }
                catch (JSchException e) {
                    throw new RemoteConnectionException(e.getMessage());
                }
            }
            this.fHostname = hostname;
            this.fPort = port;
            if (this.fPort == 0) {
                this.fPort = ConnectionProperties.defaultPort;
            }
            this.fCipherType = cipherType;
            if (this.fCipherType == null) {
                this.fCipherType = CipherTypes.CIPHER_DEFAULT;
            }
            this.fTimeout = timeout;
            if (this.fTimeout == 0) {
                this.fTimeout = ConnectionProperties.defaultTimeout;
            }
            try {
                this.defaultSession = this.jsch.createSession(this.fHostname, this.fPort, this.fUsername);
                this.fUserInfo.reset();
                this.defaultSession.setUserInfo((UserInfo)this.fUserInfo);
                this.defaultSession.setServerAliveInterval(300000);
                this.defaultSession.setServerAliveCountMax(6);
            }
            catch (JSchException e) {
                this.disconnect();
                throw new RemoteConnectionException(e.getMessage());
            }
            this.setSessionCipherType(this.defaultSession);
            try {
                this.jsch.connect(this.defaultSession, this.fTimeout, (IProgressMonitor)progress.newChild(90));
            }
            catch (JSchException e) {
                this.disconnect();
                throw new RemoteConnectionException(e.getMessage());
            }
            if (this.controlChannel == null) {
                this.controlChannel = new ControlChannel(this);
            }
            try {
                this.controlChannel.open((IProgressMonitor)progress.newChild(10));
            }
            catch (RemoteConnectionException e) {
                this.disconnect();
                throw new RemoteConnectionException(e.getMessage());
            }
            try {
                int i = 0;
                while (i < 3) {
                    ChannelSftp sftp = (ChannelSftp)this.defaultSession.openChannel("sftp");
                    sftp.connect();
                    boolean bInterrupted = Thread.interrupted();
                    while (sftp != null) {
                        try {
                            this.sftpChannelPool.put(sftp);
                            sftp = null;
                        }
                        catch (InterruptedException interruptedException) {
                            bInterrupted = true;
                        }
                    }
                    if (bInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                    ++i;
                }
            }
            catch (JSchException e) {
                throw new RemoteConnectionException(String.valueOf(Messages.Connection_2) + e.getMessage());
            }
            ConnectionSlot slot = new ConnectionSlot(this.defaultSession, ConnectionProperties.initialDefaultSessionLoad);
            this.connectionPool.add(slot);
            if (this.forwardingPool == null) {
                this.forwardingPool = new RemotePortForwardingPool(this);
            }
            if (this.executionManager != null) {
                this.executionManager.resetCancel();
            }
            this.executionObserver = new ExecutionObserver(this);
            this.executionObserver.start();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public synchronized IRemoteExecutionManager createRemoteExecutionManager() throws RemoteConnectionException {
        if (this.executionManager == null) {
            this.executionManager = new ExecutionManager(this);
        }
        return this.executionManager;
    }

    @Override
    public synchronized void disconnect() {
        if (this.executionManager != null) {
            this.executionManager.close();
        }
        if (this.executionObserver != null) {
            this.executionObserver.cancel();
        }
        if (this.controlChannel != null) {
            this.controlChannel.close();
        }
        boolean bInterrupted = Thread.interrupted();
        while (!this.sftpChannelPool.isEmpty()) {
            try {
                this.sftpChannelPool.take().disconnect();
            }
            catch (InterruptedException interruptedException) {
                bInterrupted = true;
            }
        }
        this.sftpChannelPool.clear();
        if (bInterrupted) {
            Thread.currentThread().interrupt();
        }
        for (ConnectionSlot slot : this.connectionPool) {
            slot.session.disconnect();
        }
        this.connectionPool.clear();
        this.defaultSession = null;
        if (this.forwardingPool != null) {
            this.forwardingPool.disconnect();
        }
    }

    public String getHostname() {
        return this.fHostname;
    }

    public int getPort() {
        return this.fPort;
    }

    public Session getSession() {
        return this.defaultSession;
    }

    public ChannelSftp getSFTPChannel() throws RemoteConnectionException {
        try {
            ChannelSftp channel = null;
            boolean bInterrupted = Thread.interrupted();
            while (channel == null) {
                try {
                    channel = this.sftpChannelPool.take();
                }
                catch (InterruptedException interruptedException) {
                    bInterrupted = true;
                }
            }
            if (bInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (!channel.isConnected()) {
                channel = (ChannelSftp)this.defaultSession.openChannel("sftp");
                channel.connect();
            }
            return channel;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateSFTPConnection, e);
        }
    }

    public int getTimeout() {
        return this.fTimeout;
    }

    public String getUsername() {
        return this.fUsername;
    }

    @Override
    public synchronized boolean isConnected() {
        if (this.defaultSession == null) {
            return false;
        }
        try {
            this.test();
        }
        catch (RemoteConnectionException remoteConnectionException) {
            return false;
        }
        return this.defaultSession.isConnected();
    }

    public void releaseSFTPChannel(ChannelSftp channel) {
        boolean bInterrupted = Thread.interrupted();
        while (channel != null) {
            try {
                this.sftpChannelPool.put(channel);
                channel = null;
            }
            catch (InterruptedException interruptedException) {
                bInterrupted = true;
            }
        }
        if (bInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private ConnectionSlot createConnectionSlot() throws RemoteConnectionException {
        Session newSession = null;
        try {
            newSession = this.jsch.createSession(this.fHostname, this.fPort, this.fUsername);
            this.fUserInfo.reset();
            newSession.setUserInfo((UserInfo)this.fUserInfo);
            newSession.setServerAliveInterval(300000);
            newSession.setServerAliveCountMax(6);
            this.setSessionCipherType(newSession);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateConnectionSlot_FailedCreateNewSession, e);
        }
        try {
            newSession.connect(this.fTimeout);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateConnectionSlot_FailedConnectNewSession, e);
        }
        ConnectionSlot slot = new ConnectionSlot(newSession);
        this.connectionPool.add(slot);
        return slot;
    }

    private void setSessionCipherType(Session session) {
        if (!this.fCipherType.equals(CipherTypes.CIPHER_DEFAULT)) {
            if (!CipherTypes.getCipherTypesMap().containsKey(this.fCipherType)) {
                throw new RuntimeException(Messages.Connection_SetCipherType_CipherNotSupported);
            }
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("cipher.s2c", this.fCipherType);
            config.put("cipher.c2s", this.fCipherType);
            session.setConfig(config);
        }
    }

    protected ChannelExec createExecChannel(boolean isInConnectionPool) throws RemoteConnectionException {
        if (isInConnectionPool) {
            ChannelExec channel;
            ConnectionSlot suggestedSlot = null;
            for (ConnectionSlot slot : this.connectionPool) {
                if (!slot.acquire()) continue;
                suggestedSlot = slot;
                break;
            }
            if (suggestedSlot == null) {
                suggestedSlot = this.createConnectionSlot();
                boolean isAcquired = suggestedSlot.acquire();
                assert (isAcquired);
            }
            try {
                channel = (ChannelExec)suggestedSlot.session.openChannel("exec");
            }
            catch (JSchException e) {
                suggestedSlot.release();
                throw new RemoteConnectionException(Messages.Connection_CreateExecChannel_FailedCreateNewExecChannel, e);
            }
            this.channelToConnectioPool.put((Channel)channel, suggestedSlot);
            return channel;
        }
        try {
            return (ChannelExec)this.defaultSession.openChannel("exec");
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateExecChannel_FailedCreateNewExecChannel, e);
        }
    }

    protected synchronized int createNextPIID() {
        return ++this.nextInternalPID % Integer.MAX_VALUE;
    }

    protected RemoteTunnel createTunnel(int localPort, String addressOnRemoteHost, int portOnRemoteHost) throws RemoteConnectionException, LocalPortBoundException {
        RemoteTunnel tunnel = new RemoteTunnel(localPort, portOnRemoteHost, addressOnRemoteHost);
        if (this.tunnels.contains(tunnel)) {
            throw new LocalPortBoundException(Messages.Connection_CreateTunnel_TunnelPortAlreadyAlloced);
        }
        try {
            this.defaultSession.setPortForwardingL(tunnel.getLocalPort(), tunnel.getAddressOnRemoteHost(), tunnel.getPortOnRemoteHost());
        }
        catch (JSchException e) {
            if (e.getMessage().matches("PortForwardingL: local port .* is already registered.")) {
                throw new LocalPortBoundException(Messages.Connection_CreateTunnel_TunnelPortAlreadyAlloced);
            }
            throw new RemoteConnectionException(Messages.Connection_CreateTunnel_FailedCreateTunnel, e);
        }
        this.tunnels.add(tunnel);
        return tunnel;
    }

    protected Hashtable<Integer, KillableExecution> getActiveProcessTable() {
        return this.activeProcessTable;
    }

    protected RemotePortForwardingPool getForwardingPool() {
        return this.forwardingPool;
    }

    protected String getKillablePrefix(KillableExecution execution) {
        return this.controlChannel.getKillablePrefix(execution.getInternalID());
    }

    protected void killExecution(KillableExecution execution) {
        this.controlChannel.killRemoteProcess(execution.getPID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerObservedExecution(IRemoteOperation operation) {
        if (operation instanceof KillableExecution) {
            KillableExecution killableExecution = (KillableExecution)operation;
            Hashtable<Integer, KillableExecution> hashtable = this.getActiveProcessTable();
            synchronized (hashtable) {
                this.getActiveProcessTable().put(new Integer(killableExecution.getInternalID()), killableExecution);
            }
        }
    }

    protected void releaseChannel(Channel channel) {
        channel.disconnect();
        ConnectionSlot slot = this.channelToConnectioPool.remove(channel);
        if (slot != null) {
            slot.release();
        }
    }

    protected void releaseTunnel(RemoteTunnel tunnel) throws RemoteConnectionException {
        if (!this.tunnels.contains(tunnel)) {
            throw new RemoteConnectionException(Messages.Connection_ReleaseTunnel_PortNotAllocedForTunnel);
        }
        try {
            RemoteTunnel remoteTunnel = tunnel;
            this.defaultSession.delPortForwardingL(remoteTunnel.getLocalPort());
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_ReleaseTunnel_FailedRemoveTunnel, e);
        }
        this.tunnels.remove(tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPID(int piid, int pid) {
        Hashtable<Integer, KillableExecution> hashtable = this.getActiveProcessTable();
        synchronized (hashtable) {
            KillableExecution exec = this.getActiveProcessTable().get(new Integer(piid));
            if (exec != null) {
                exec.setPID(pid);
            }
        }
    }

    protected synchronized void test() throws RemoteConnectionException {
        for (ConnectionSlot slot : this.connectionPool) {
            if (slot.session.isConnected()) continue;
            throw new RemoteConnectionException(Messages.Connection_0);
        }
        if (this.controlChannel == null || !this.controlChannel.isConnected()) {
            throw new RemoteConnectionException(Messages.Connection_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterObservedExecution(IRemoteOperation operation) {
        if (operation instanceof KillableExecution) {
            KillableExecution killableExecution = (KillableExecution)operation;
            Hashtable<Integer, KillableExecution> hashtable = this.getActiveProcessTable();
            synchronized (hashtable) {
                this.getActiveProcessTable().remove(new Integer(killableExecution.getInternalID()));
            }
        }
    }

    private class ConnectionSlot {
        Session session = null;
        int numberUsedChannels = 0;

        ConnectionSlot(Session session) {
            this.session = session;
        }

        ConnectionSlot(Session session, int initialLoad) {
            assert (initialLoad <= ConnectionProperties.maxChannelsPerConnection);
            this.session = session;
            this.numberUsedChannels = initialLoad;
        }

        synchronized boolean acquire() {
            if (this.numberUsedChannels < ConnectionProperties.maxChannelsPerConnection) {
                ++this.numberUsedChannels;
                return true;
            }
            return false;
        }

        void release() {
            --this.numberUsedChannels;
        }
    }

    private class SSHUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final IAuthInfo fAuthInfo;
        private boolean firstTry = true;

        private SSHUserInfo(IAuthInfo authInfo) {
            this.fAuthInfo = authInfo;
        }

        public String getPassphrase() {
            return this.fAuthInfo.getPassphrase();
        }

        public String getPassword() {
            return this.fAuthInfo.getPassword();
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.firstTry && !this.getPassword().equals("") && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.firstTry = false;
                return new String[]{this.getPassword()};
            }
            return this.fAuthInfo.promptKeyboardInteractive(destination, name, instruction, prompt, echo);
        }

        public boolean promptPassphrase(String message) {
            if (this.firstTry && !this.getPassphrase().equals("")) {
                this.firstTry = false;
                return true;
            }
            return this.fAuthInfo.promptPassphrase(message);
        }

        public boolean promptPassword(String message) {
            if (this.firstTry && !this.getPassword().equals("")) {
                this.firstTry = false;
                return true;
            }
            return this.fAuthInfo.promptPassword(message);
        }

        public boolean promptYesNo(String str) {
            return this.fAuthInfo.promptYesNo(str);
        }

        public void reset() {
            this.firstTry = true;
        }

        public void showMessage(String message) {
            this.fAuthInfo.showMessage(message);
        }
    }
}

