/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remotetools.core.IAuthInfo;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.environment.control.ITargetConfig;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.generichost.Activator;
import org.eclipse.ptp.remotetools.environment.generichost.messages.Messages;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;

public class TargetControl
extends SSHTargetControl
implements ITargetControl {
    private final ITargetConfig fTargetConfig;
    private IRemoteExecutionManager executionManager;
    private int state = 1;
    private static final int NOT_OPERATIONAL = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int DISCONNECTING = 4;
    private final IAuthInfo fAuthInfo;

    public TargetControl(ITargetConfig config, IAuthInfo authInfo) throws CoreException {
        this.fTargetConfig = config;
        this.fAuthInfo = authInfo;
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        block5: {
            monitor.beginTask(Messages.TargetControl_create_MonitorConnecting, 1);
            this.setConnectionParameters(this.fTargetConfig, this.fAuthInfo);
            try {
                this.setState(2);
                super.create(monitor);
                if (!monitor.isCanceled()) break block5;
                this.disconnect();
                this.setState(1);
                monitor.done();
                return true;
            }
            catch (CoreException e) {
                this.disconnect();
                this.setState(1);
                monitor.done();
                throw e;
            }
        }
        this.setState(3);
        monitor.worked(1);
        try {
            this.executionManager = super.createRemoteExecutionManager();
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            this.setState(1);
            throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
        }
        monitor.done();
        return true;
    }

    public IRemoteExecutionManager createExecutionManager() throws RemoteConnectionException {
        if (!this.isConnected()) {
            throw new RemoteConnectionException(Messages.TargetControl_Connection_is_not_open);
        }
        return super.createRemoteExecutionManager();
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) {
        Assert.isTrue((boolean)this.isConnected());
        ITargetControl.TargetSocket socket = new ITargetControl.TargetSocket();
        socket.host = this.fTargetConfig.getConnectionAddress();
        socket.port = port;
        return socket;
    }

    public void destroy() throws CoreException {
        this.disconnect();
    }

    public ITargetConfig getConfig() {
        return this.fTargetConfig;
    }

    public IRemoteExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public void kill() throws CoreException {
        try {
            this.setState(4);
            super.kill();
        }
        finally {
            this.setState(1);
        }
    }

    public synchronized int query() {
        switch (this.state) {
            case 1: {
                return 1;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                if (this.isConnected()) {
                    return 2;
                }
                return 0;
            }
        }
        return 1;
    }

    public boolean resume(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 0, Messages.TargetControl_resume_CannotResume, null));
    }

    public boolean stop(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 0, Messages.TargetControl_stop_CannotPause, null));
    }

    public void updateConfiguration() throws CoreException {
    }

    private synchronized void setState(int state) {
        this.state = state;
    }
}

