/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.ptp.remotetools.environment.generichost.Activator;
import org.eclipse.ptp.remotetools.environment.generichost.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserValidationDialog
extends TrayDialog {
    private final String KEYLOCK_ICON = "icons/full/wizban/keylock.gif";
    protected Text usernameField;
    protected Text passwordField;
    protected Button savePasswordButton;
    protected String defaultUsername;
    protected String password = null;
    protected boolean savePassword = false;
    protected Image keyLockImage;
    protected boolean isUsernameMutable = true;
    protected String username = null;
    protected String message = null;

    public UserValidationDialog(Shell parentShell, String defaultName, String message) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultUsername = defaultName;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UserValidationDialog_Password_required);
    }

    public void create() {
        super.create();
        this.usernameField.setText(this.defaultUsername);
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
            this.usernameField.setFocus();
        } else {
            this.usernameField.setEditable(false);
            this.passwordField.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = Activator.getImageDescriptor("icons/full/wizban/keylock.gif").createImage();
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 300;
            messageLabel.setLayoutData((Object)data);
        }
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        this.savePasswordButton = new Button(main, 32);
        this.savePasswordButton.setText(Messages.UserValidationDialog_Save_password);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.savePasswordButton.setLayoutData((Object)data);
        this.savePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserValidationDialog.this.savePassword = UserValidationDialog.this.savePasswordButton.getSelection();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(Messages.UserValidationDialog_Password);
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(Messages.UserValidationDialog_3);
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.username = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }
}

