/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.internal.runnable.command;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlConstants;
import org.eclipse.ptp.rm.jaxb.control.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.control.JAXBResourceManagerControl;
import org.eclipse.ptp.rm.jaxb.control.data.ArgImpl;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJob;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStatus;
import org.eclipse.ptp.rm.jaxb.control.internal.ICommandJobStreamsProxy;
import org.eclipse.ptp.rm.jaxb.control.internal.IStreamParserTokenizer;
import org.eclipse.ptp.rm.jaxb.control.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJobStreamMonitor;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.CommandJobStreamsProxy;
import org.eclipse.ptp.rm.jaxb.control.internal.runnable.command.ConfigurableRegexTokenizer;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.DebuggingLogger;
import org.eclipse.ptp.rm.jaxb.control.internal.utils.EnvironmentVariableUtils;
import org.eclipse.ptp.rm.jaxb.core.IJAXBResourceManager;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.ptp.rm.jaxb.core.data.NameValuePairType;
import org.eclipse.ptp.rm.jaxb.core.data.TokenizerType;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.utils.core.ArgumentParser;

public class CommandJob
extends Job
implements ICommandJob {
    private final String uuid;
    private final CommandType command;
    private final IJAXBResourceManager rm;
    private final JAXBResourceManagerControl control;
    private final ICommandJobStreamsProxy proxy;
    private final IVariableMap rmVarMap;
    private final int flags;
    private final boolean waitForId;
    private final JobMode jobMode;
    private final boolean keepOpen;
    private final String launchMode;
    private final List<Job> cmdJobs = new ArrayList<Job>();
    private final StringBuffer error;
    private Thread jobThread;
    private IRemoteProcess process;
    private IStreamParserTokenizer stdoutTokenizer;
    private IStreamParserTokenizer stderrTokenizer;
    private Thread stdoutT;
    private Thread stderrT;
    private InputStream tokenizerOut;
    private InputStream tokenizerErr;
    private StreamSplitter outSplitter;
    private StreamSplitter errSplitter;
    private IStreamMonitor[] batchMonitors;
    private ICommandJobStatus jobStatus;
    private IStatus status;
    private boolean active;

    public static IStreamParserTokenizer getTokenizer(String type) throws CoreException {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rm.jaxb.control.core", "streamParserTokenizer");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            try {
                if (element.getAttribute("id").equals(type)) {
                    return (IStreamParserTokenizer)element.createExecutableExtension("class");
                }
            }
            catch (CoreException ce) {
                throw ce;
            }
            catch (Throwable t) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.StreamTokenizerInstantiationError) + type), (Throwable)t);
            }
            ++i;
        }
        return null;
    }

    public CommandJob(String jobUUID, CommandType command, JobMode jobMode, IJAXBResourceManager rm, String launchMode) {
        super(String.valueOf(command.getName()) + ":" + " " + (jobUUID == null ? rm.getName() : jobUUID));
        this.command = command;
        this.jobMode = jobMode;
        this.rm = rm;
        this.launchMode = launchMode;
        this.control = (JAXBResourceManagerControl)rm.getControl();
        this.rmVarMap = this.control.getEnvironment();
        this.uuid = jobUUID;
        this.proxy = new CommandJobStreamsProxy();
        this.waitForId = command.isWaitForId();
        this.error = new StringBuffer();
        this.keepOpen = command.isKeepOpen();
        String flags = command.getFlags();
        this.flags = this.getFlags(flags);
    }

    public ICommandJobStatus getJobStatus() {
        return this.jobStatus;
    }

    public IRemoteProcess getProcess() {
        return this.process;
    }

    public ICommandJobStreamsProxy getProxy() {
        return this.proxy;
    }

    public IStatus getRunStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        boolean b = false;
        CommandJob commandJob = this;
        synchronized (commandJob) {
            b = this.active;
        }
        return b;
    }

    public boolean isBatch() {
        return this.jobMode == JobMode.BATCH;
    }

    public CoreException joinConsumers() {
        if (!this.isActive()) {
            return null;
        }
        Throwable t = null;
        if (this.outSplitter != null) {
            try {
                this.outSplitter.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.errSplitter != null) {
            try {
                this.errSplitter.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.stdoutT != null) {
            try {
                this.stdoutT.join();
            }
            catch (InterruptedException interruptedException) {}
            t = this.stdoutTokenizer.getInternalError();
        }
        if (this.stderrT != null) {
            try {
                this.stderrT.join();
            }
            catch (InterruptedException interruptedException) {}
            t = this.stderrTokenizer.getInternalError();
        }
        if (t != null) {
            return CoreExceptionUtils.newException((String)t.getMessage(), (Throwable)t);
        }
        return null;
    }

    public synchronized void terminate() {
        if (this.active) {
            this.active = false;
            if (this.jobStatus != null) {
                this.jobStatus.cancelWait();
            }
            if (this.process != null && !this.process.isCompleted()) {
                CoreException e;
                this.process.destroy();
                if (this.proxy != null) {
                    this.proxy.close();
                }
                if ((e = this.joinConsumers()) != null) {
                    JAXBControlCorePlugin.log(e);
                }
            }
            if (this.jobThread != null && this.jobThread != Thread.currentThread() && this.jobThread.isAlive()) {
                this.jobThread.interrupt();
            }
            for (Job job : this.cmdJobs) {
                if (job.getState() != 4) continue;
                job.cancel();
            }
            this.cmdJobs.clear();
            this.cancel();
        }
    }

    public boolean waitForId() {
        return this.waitForId;
    }

    private IStatus createDebugModel(String jobId, IResourceManager rm, IVariableMap vars) {
        IPResourceManager prm = (IPResourceManager)rm.getAdapter(IPResourceManager.class);
        IPJob job = prm.getJobById(jobId);
        if (job != null) {
            prm.removeJobs(Arrays.asList(job));
        }
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobId));
        attrMgr.addAttribute((IAttribute)JobAttributes.getStateAttributeDefinition().create((Enum)JobAttributes.State.RUNNING));
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(Boolean.valueOf(true)));
        job = prm.newJob(jobId, attrMgr);
        attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.RUNNING));
        Object attr = this.getAttributeValue(vars, "mpiNumberOfProcesses");
        if (attr != null) {
            int numProcs;
            String numProcsStr = String.valueOf(attr);
            try {
                numProcs = Integer.parseInt(numProcsStr);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), Messages.CommandJob_UnableToDetermineTasksError);
            }
            BitSet procRanks = new BitSet(numProcs);
            procRanks.set(0, numProcs, true);
            job.addProcessesByJobRanks(procRanks, attrMgr);
            prm.addJobs(null, Arrays.asList(job));
            return Status.OK_STATUS;
        }
        return new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), Messages.CommandJob_UnableToDetermineTasksError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus execute(IProgressMonitor monitor) {
        CommandJob commandJob;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            commandJob = this;
            synchronized (commandJob) {
                this.status = null;
                this.active = false;
            }
            IRemoteProcessBuilder builder = this.prepareCommand((IProgressMonitor)progress.newChild(10));
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.prepareEnv(builder);
            progress.worked(10);
            this.process = null;
            try {
                this.process = builder.start(this.flags);
            }
            catch (IOException t) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(Messages.CouldNotLaunch) + builder.command()), (Throwable)t);
            }
            progress.worked(30);
            this.maybeInitializeTokenizers(builder, (IProgressMonitor)progress.newChild(10));
            this.setOutStreamRedirection(this.process);
            this.setErrStreamRedirection(this.process);
            this.startConsumers(this.process);
            CommandJob t = this;
            synchronized (t) {
                this.active = true;
            }
            progress.worked(20);
            int exit = 0;
            if (this.uuid != null) {
                if (!this.waitForId) {
                    try {
                        exit = this.process.exitValue();
                    }
                    catch (Throwable throwable) {}
                    if (exit != 0 || this.error.length() > 0) {
                        this.processError((String)builder.command().get(0), exit, null);
                    }
                    return Status.OK_STATUS;
                }
                if (this.keepOpen) {
                    this.control.setInteractiveJob(this);
                    return Status.OK_STATUS;
                }
            }
            try {
                exit = this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            CoreException e = this.joinConsumers();
            if (exit != 0) {
                this.processError((String)builder.command().get(0), exit, e);
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        catch (Throwable t) {
            return CoreExceptionUtils.getErrorStatus((String)Messages.ProcessRunError, (Throwable)t);
        }
        commandJob = this;
        synchronized (commandJob) {
            this.active = false;
        }
        return Status.OK_STATUS;
    }

    private Object getAttributeValue(IVariableMap vars, String name) {
        AttributeType attr = (AttributeType)vars.get(name);
        if (attr != null) {
            Object linkVal;
            String link = attr.getLinkValueTo();
            if (link != null && (linkVal = this.getAttributeValue(vars, link)) != null) {
                return linkVal;
            }
            return attr.getValue();
        }
        return null;
    }

    private int getFlags(String flags) {
        if (flags == null) {
            return 0;
        }
        String[] split = flags.split("[|]");
        int f = 0;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("ALLOCATE_PTY".equals(s = s.trim())) {
                f |= 1;
            } else if ("FORWARD_X11".equals(s)) {
                f |= 2;
            }
            ++n2;
        }
        return f;
    }

    private void maybeInitializeTokenizers(IRemoteProcessBuilder builder, IProgressMonitor monitor) throws CoreException {
        block15: {
            String type;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            TokenizerType t = null;
            if (builder.redirectErrorStream()) {
                t = this.command.getRedirectParser();
            }
            if (t == null) {
                t = this.command.getStdoutParser();
            }
            if (t != null) {
                try {
                    type = t.getType();
                    this.stdoutTokenizer = type != null ? CommandJob.getTokenizer(type) : new ConfigurableRegexTokenizer(t);
                    this.stdoutTokenizer.initialize(this.uuid, this.rmVarMap, (IProgressMonitor)progress.newChild(50));
                    if (progress.isCanceled()) {
                        return;
                    }
                }
                catch (Throwable e) {
                    throw CoreExceptionUtils.newException((String)Messages.StdoutParserError, (Throwable)e);
                }
            }
            if ((t = this.command.getStderrParser()) == null) break block15;
            try {
                type = t.getType();
                this.stderrTokenizer = type != null ? CommandJob.getTokenizer(type) : new ConfigurableRegexTokenizer(t);
                this.stderrTokenizer.initialize(this.uuid, this.rmVarMap, (IProgressMonitor)progress.newChild(50));
                if (progress.isCanceled()) {
                    return;
                }
            }
            catch (Throwable e) {
                throw CoreExceptionUtils.newException((String)Messages.StdoutParserError, (Throwable)e);
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private IRemoteProcessBuilder prepareCommand(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            List args = this.command.getArg();
            if (args == null) {
                throw CoreExceptionUtils.newException((String)Messages.MissingArglistFromCommandError, null);
            }
            ArgumentParser cmdArgs = new ArgumentParser(ArgImpl.getArgs(this.uuid, args, this.rmVarMap));
            RemoteServicesDelegate delegate = this.control.getRemoteServicesDelegate((IProgressMonitor)progress.newChild(5));
            if (progress.isCanceled()) {
                return null;
            }
            if (delegate.getRemoteConnection() == null) {
                throw CoreExceptionUtils.newException((String)Messages.MissingArglistFromCommandError, (Throwable)new Throwable(Messages.UninitializedRemoteServices));
            }
            IRemoteConnection conn = delegate.getRemoteConnection();
            try {
                JAXBResourceManagerControl.checkConnection(conn, progress.newChild(5));
            }
            catch (RemoteConnectionException rce) {
                throw CoreExceptionUtils.newException((String)rce.getLocalizedMessage(), (Throwable)rce);
            }
            if (progress.isCanceled()) {
                return null;
            }
            if (DebuggingLogger.getLogger().getCommand()) {
                System.out.println(String.valueOf(this.getName()) + ": " + cmdArgs.getCommandLine(false));
            }
            IRemoteProcessBuilder builder = delegate.getRemoteServices().getProcessBuilder(conn, cmdArgs.getTokenList());
            String directory = this.command.getDirectory();
            if (directory != null && !"".equals(directory)) {
                directory = this.rmVarMap.getString(this.uuid, directory);
                IFileStore dir = delegate.getRemoteFileManager().getResource(directory);
                builder.directory(dir);
            }
            IRemoteProcessBuilder iRemoteProcessBuilder = builder;
            return iRemoteProcessBuilder;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void prepareEnv(IRemoteProcessBuilder builder) throws CoreException {
        if (!this.control.getAppendEnv()) {
            builder.environment().clear();
            Map<String, String> live = this.control.getLaunchEnv();
            for (String var : live.keySet()) {
                builder.environment().put(var, live.get(var));
            }
        } else {
            if (this.command.isReplaceEnvironment()) {
                builder.environment().clear();
            }
            List vars = this.command.getEnvironment();
            for (NameValuePairType var : vars) {
                EnvironmentVariableUtils.addVariable(this.uuid, var, builder.environment(), this.rmVarMap);
            }
            Map<String, String> live = this.control.getLaunchEnv();
            for (String var : live.keySet()) {
                builder.environment().put(var, live.get(var));
            }
        }
        builder.redirectErrorStream(this.command.isRedirectStderr());
    }

    private String prepareInput() throws CoreException {
        List args = this.command.getInput();
        return ArgImpl.toString(this.uuid, args, this.control.getEnvironment());
    }

    private void processError(String arg, int exit, CoreException e) throws CoreException {
        if (e != null) {
            this.error.append(e.getMessage()).append(JAXBControlConstants.LINE_SEP);
        }
        String message = this.error.toString();
        this.error.setLength(0);
        throw CoreExceptionUtils.newException((String)(String.valueOf(arg) + " " + Messages.ProcessExitValueError + exit + JAXBControlConstants.LINE_SEP + message), null);
    }

    private void setErrStreamRedirection(IRemoteProcess process) throws IOException {
        if (this.stderrTokenizer == null) {
            this.proxy.setErrMonitor(new CommandJobStreamMonitor(process.getErrorStream()));
        } else {
            PipedInputStream tokenizerErr = new PipedInputStream();
            this.tokenizerErr = tokenizerErr;
            PipedInputStream monitorErr = new PipedInputStream();
            this.errSplitter = new StreamSplitter(process.getErrorStream(), tokenizerErr, monitorErr);
            this.proxy.setErrMonitor(new CommandJobStreamMonitor(monitorErr));
        }
        this.proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                CommandJob.this.error.append(text);
            }
        });
    }

    private void setOutStreamRedirection(IRemoteProcess process) throws IOException {
        if (this.stdoutTokenizer == null) {
            this.proxy.setOutMonitor(new CommandJobStreamMonitor(process.getInputStream()));
        } else {
            PipedInputStream tokenizerOut = new PipedInputStream();
            this.tokenizerOut = tokenizerOut;
            PipedInputStream monitorOut = new PipedInputStream();
            this.outSplitter = new StreamSplitter(process.getInputStream(), tokenizerOut, monitorOut);
            this.proxy.setOutMonitor(new CommandJobStreamMonitor(monitorOut));
        }
    }

    private void startConsumers(IRemoteProcess process) throws CoreException {
        if (this.outSplitter != null) {
            this.outSplitter.start();
        }
        if (this.errSplitter != null) {
            this.errSplitter.start();
        }
        this.proxy.startMonitors();
        if (this.isBatch()) {
            this.batchMonitors = new IStreamMonitor[2];
            this.batchMonitors[0] = this.proxy.getOutputStreamMonitor();
            this.batchMonitors[1] = this.proxy.getErrorStreamMonitor();
            this.proxy.setOutMonitor(null);
            this.proxy.setErrMonitor(null);
        }
        if (this.stdoutTokenizer != null) {
            try {
                this.stdoutTokenizer.setInputStream(this.tokenizerOut);
                this.stdoutT = new Thread(this.stdoutTokenizer);
                this.stdoutT.start();
            }
            catch (Throwable e) {
                throw CoreExceptionUtils.newException((String)Messages.StdoutParserError, (Throwable)e);
            }
        }
        if (this.stderrTokenizer != null) {
            try {
                this.stderrTokenizer.setInputStream(this.tokenizerErr);
                this.stderrT = new Thread(this.stderrTokenizer);
                this.stderrT.start();
            }
            catch (Throwable e) {
                throw CoreExceptionUtils.newException((String)Messages.StderrParserError, (Throwable)e);
            }
        }
    }

    private IStatus writeInputToProcess(IRemoteProcess process) {
        OutputStream stream = process.getOutputStream();
        try {
            stream.write(this.prepareInput().getBytes());
            stream.write(JAXBControlConstants.LINE_SEP.getBytes());
            stream.flush();
        }
        catch (Throwable t) {
            return CoreExceptionUtils.getErrorStatus((String)Messages.ProcessRunError, (Throwable)t);
        }
        return Status.OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobMode {
        BATCH,
        STATUS,
        INTERACTIVE;

    }

    private class StreamSplitter
    extends Thread {
        private final InputStream in;
        private final PipedOutputStream[] pout;
        private final List<BufferedOutputStream> boutList;

        private StreamSplitter(InputStream in, PipedInputStream pipe1, PipedInputStream pipe2) throws IOException {
            this.in = in;
            assert (pipe1 != null && pipe2 != null);
            this.pout = new PipedOutputStream[]{new PipedOutputStream(pipe1), new PipedOutputStream(pipe2)};
            this.boutList = new ArrayList<BufferedOutputStream>();
            this.boutList.add(new BufferedOutputStream(this.pout[0], 8192));
            this.boutList.add(new BufferedOutputStream(this.pout[1], 8192));
        }

        public void run() {
            BufferedInputStream bin = new BufferedInputStream(this.in);
            try {
                int i;
                while ((i = bin.read()) != -1) {
                    BufferedOutputStream stream = null;
                    Iterator<BufferedOutputStream> b = this.boutList.iterator();
                    while (b.hasNext()) {
                        try {
                            stream = b.next();
                            stream.write(i);
                            stream.flush();
                        }
                        catch (IOException dead) {
                            if (dead.getMessage().indexOf("dead") >= 0) {
                                b.remove();
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            throw dead;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException t) {
                JAXBControlCorePlugin.log(t);
            }
            for (BufferedOutputStream b : this.boutList) {
                try {
                    b.close();
                }
                catch (IOException t) {
                    JAXBControlCorePlugin.log(t);
                }
            }
        }
    }
}

