/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.InfoTreeNodeModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ValueTreeNodeUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.TemplateType;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class ViewerUpdateModel
extends AbstractUpdateModel
implements ICheckStateListener,
SelectionListener {
    private final StringBuffer checked;
    private final StringBuffer templatedValue;
    private final String pattern;
    private final String separator;
    private final ICheckable viewer;
    private final ColumnViewer columnViewer;
    private final boolean initialAllChecked;
    private Button showOnlySelected;
    private final ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ICellEditorUpdateModel) {
                return ((ICheckable)viewer).getChecked(element);
            }
            if (element instanceof InfoTreeNodeModel) {
                ValueTreeNodeUpdateModel parent = ((InfoTreeNodeModel)element).getParent();
                return ((ICheckable)viewer).getChecked((Object)parent);
            }
            return false;
        }
    };

    public ViewerUpdateModel(String name, boolean initialAllChecked, ValueUpdateHandler handler, ICheckable viewer, TemplateType template) {
        super(name, handler);
        this.viewer = viewer;
        this.columnViewer = (ColumnViewer)viewer;
        this.initialAllChecked = initialAllChecked;
        String s = null;
        if (template == null) {
            this.pattern = null;
        } else {
            this.pattern = template.getPattern();
            s = template.getSeparator();
        }
        this.separator = s == null ? "" : s;
        this.checked = new StringBuffer();
        this.templatedValue = new StringBuffer();
        viewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        try {
            Object element = event.getElement();
            if (!(element instanceof ICellEditorUpdateModel)) {
                this.viewer.setChecked(element, false);
                return;
            }
            boolean checked = this.viewer.getChecked(element);
            IStructuredSelection selection = (IStructuredSelection)((ColumnViewer)this.viewer).getSelection();
            ArrayList<Object> selected = new ArrayList<Object>();
            selected.add(element);
            selected.addAll(selection.toList());
            if (!selected.isEmpty()) {
                for (Object e : selected) {
                    if (e instanceof ICellEditorUpdateModel) {
                        ICellEditorUpdateModel model = (ICellEditorUpdateModel)e;
                        model.setChecked(checked);
                        this.viewer.setChecked((Object)model, checked);
                        continue;
                    }
                    this.viewer.setChecked(e, false);
                }
            }
        }
        catch (Throwable t) {
            JAXBControlUIPlugin.log(t);
        }
        this.handleUpdate(null);
    }

    public Object getControl() {
        return this.viewer;
    }

    public Control getSWTControl() {
        if (this.columnViewer instanceof CheckboxTableViewer) {
            return ((CheckboxTableViewer)this.columnViewer).getTable();
        }
        if (this.columnViewer instanceof CheckboxTreeViewer) {
            return ((CheckboxTreeViewer)this.columnViewer).getTree();
        }
        return null;
    }

    public Object getValueFromControl() {
        return this.mapValue;
    }

    public void initializeChecked() throws CoreException {
        Set<String> allChecked = this.lcMap.getChecked(this.name);
        Collection input = (Collection)((Viewer)this.viewer).getInput();
        for (Object o : input) {
            boolean checked = false;
            if (o instanceof ICellEditorUpdateModel) {
                ICellEditorUpdateModel model = (ICellEditorUpdateModel)o;
                checked = allChecked.isEmpty() ? this.initialAllChecked : allChecked.contains(model.getName());
                model.setChecked(checked);
                this.viewer.setChecked((Object)model, checked);
                continue;
            }
            this.viewer.setChecked(o, false);
        }
        Boolean b = (Boolean)this.lcMap.get("show_only_checked" + this.name);
        if (b == null) {
            b = false;
        }
        this.showOnlySelected.setSelection(b.booleanValue());
        if (b.booleanValue()) {
            this.columnViewer.addFilter(this.filter);
        }
        this.handleUpdate(null);
    }

    public void putCheckedSettings(LCVariableMap lcMap) {
        this.checked.setLength(0);
        Collection input = (Collection)((Viewer)this.viewer).getInput();
        for (Object o : input) {
            String name;
            ICellEditorUpdateModel model;
            if (!(o instanceof ICellEditorUpdateModel) || !(model = (ICellEditorUpdateModel)o).isChecked() || (name = model.getName()) == null || "".equals(name)) continue;
            this.checked.append(model.getName()).append(" ");
        }
        lcMap.put("checked_attributes_" + this.name, this.checked.toString().trim());
        lcMap.put("show_only_checked" + this.name, this.showOnlySelected.getSelection());
    }

    public void refreshValueFromMap() {
    }

    public void setShowAll(Button showOnlySelected) {
        this.showOnlySelected = showOnlySelected;
    }

    public Object storeValue() {
        String t;
        this.templatedValue.setLength(0);
        if (this.pattern != null) {
            Collection input = (Collection)((Viewer)this.viewer).getInput();
            for (Object o : input) {
                ICellEditorUpdateModel model;
                String replaced;
                if (!(o instanceof ICellEditorUpdateModel) || "".equals(replaced = (model = (ICellEditorUpdateModel)o).getReplacedValue(this.pattern))) continue;
                this.templatedValue.append(this.separator).append(replaced);
            }
            this.templatedValue.delete(0, this.separator.length());
        }
        if (!"".equals(t = this.templatedValue.toString().trim())) {
            t = this.lcMap.getString(t);
        }
        this.lcMap.put(this.name, t);
        this.mapValue = t;
        return t;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.showOnlySelected.getSelection()) {
            this.columnViewer.addFilter(this.filter);
        } else {
            this.columnViewer.removeFilter(this.filter);
        }
        this.handleUpdate(null);
    }
}

