/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.providers;

import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ptp.rm.jaxb.control.ui.IColumnViewerLabelSupport;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.core.data.ColumnDataType;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerDataCellLabelProvider
extends CellLabelProvider {
    private final List<ColumnDataType> columnData;

    public ViewerDataCellLabelProvider(List<ColumnDataType> columnData) {
        this.columnData = columnData;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 500;
    }

    public String getToolTipText(Object element) {
        if (element instanceof IColumnViewerLabelSupport) {
            IColumnViewerLabelSupport support = (IColumnViewerLabelSupport)element;
            return support.getTooltip();
        }
        return super.getToolTipText(element);
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 3000;
    }

    public void update(ViewerCell cell) {
        Image img;
        Font font;
        int index = cell.getColumnIndex();
        Object element = cell.getElement();
        Color color = this.getBackground(element, index);
        if (color != null) {
            cell.setBackground(color);
        }
        if ((color = this.getForeground(element, index)) != null) {
            cell.setBackground(color);
        }
        if ((font = this.getFont(element, index)) != null) {
            cell.setFont(font);
        }
        if ((img = this.getColumnImage(element, index)) != null) {
            cell.setImage(img);
        }
        cell.setText(this.getColumnText(element, index));
    }

    private Color getBackground(Object element, int columnIndex) {
        if (element instanceof IColumnViewerLabelSupport) {
            IColumnViewerLabelSupport support = (IColumnViewerLabelSupport)element;
            return support.getBackground(element, columnIndex);
        }
        return null;
    }

    private Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof IColumnViewerLabelSupport) {
            IColumnViewerLabelSupport support = (IColumnViewerLabelSupport)element;
            return support.getColumnImage(this.getColumnName(columnIndex));
        }
        return null;
    }

    private String getColumnName(int columnIndex) {
        if (columnIndex >= this.columnData.size()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(Messages.ViewerLabelProviderColumnError) + columnIndex);
        }
        return this.columnData.get(columnIndex).getName();
    }

    private String getColumnText(Object element, int columnIndex) {
        if (element instanceof IColumnViewerLabelSupport) {
            IColumnViewerLabelSupport support = (IColumnViewerLabelSupport)element;
            return support.getDisplayValue(this.getColumnName(columnIndex));
        }
        return "";
    }

    private Font getFont(Object element, int columnIndex) {
        if (element instanceof IColumnViewerLabelSupport) {
            IColumnViewerLabelSupport support = (IColumnViewerLabelSupport)element;
            return support.getFont(element, columnIndex);
        }
        return null;
    }

    private Color getForeground(Object element, int columnIndex) {
        Color color = null;
        if (element instanceof IColumnViewerLabelSupport) {
            IColumnViewerLabelSupport support = (IColumnViewerLabelSupport)element;
            color = support.getForeground(element, columnIndex);
        }
        return color;
    }
}

