/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

public class JobStatusData {
    private static final String JOB_OUTERR_READY = "JOB_OUTERR_READY";
    public static final String SUBMITTED = "SUBMITTED";
    public static final String RUNNING = "RUNNING";
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String CANCELED = "CANCELED";
    private final String fRmId;
    private final String fJobId;
    private final String fOutputPath;
    private final String fErrorPath;
    private final String fQueueName;
    private final String fOwner;
    private final boolean fInteractive;
    private String fState = "SUBMITTED";
    private String fStateDetail = "SUBMITTED";
    private boolean fOutReady = false;
    private boolean fErrReady = false;
    private String fOid;
    private boolean fRemoved = false;

    private static boolean detailIsFinal(String detail) {
        return CANCELED.equals(detail) || FAILED.equals(detail) || JOB_OUTERR_READY.equals(detail);
    }

    public JobStatusData(String rmId, String jobId, String queueName, String owner, String outputPath, String errorPath, boolean interactive) {
        this.fRmId = rmId;
        this.fJobId = jobId;
        this.fQueueName = queueName;
        this.fOwner = owner;
        this.fOutputPath = outputPath;
        this.fErrorPath = errorPath;
        this.fInteractive = interactive;
    }

    public JobStatusData(String jobId, String rmId, String state, String stateDetail, String outputPath, String errorPath, boolean interactive, String queueName, String owner, String oid) {
        this(rmId, jobId, queueName, owner, outputPath, errorPath, interactive);
        this.fState = state;
        this.fStateDetail = stateDetail;
        this.fOid = oid;
        this.fOutReady = this.fOutputPath != null && JOB_OUTERR_READY.equals(this.fStateDetail);
        this.fErrReady = this.fErrorPath != null && JOB_OUTERR_READY.equals(this.fStateDetail);
    }

    public String getErrorPath() {
        return this.fErrorPath;
    }

    public boolean getErrReady() {
        return this.fErrReady;
    }

    public String getJobId() {
        return this.fJobId;
    }

    public String getOid() {
        return this.fOid;
    }

    public String getOutputPath() {
        return this.fOutputPath;
    }

    public boolean getOutReady() {
        return this.fOutReady;
    }

    public String getOwner() {
        return this.fOwner;
    }

    public String getQueueName() {
        return this.fQueueName;
    }

    public String getRmId() {
        return this.fRmId;
    }

    public String getState() {
        return this.fState;
    }

    public String getStateDetail() {
        return this.fStateDetail;
    }

    public boolean isCompleted() {
        return this.fState.equals(COMPLETED);
    }

    public boolean isInteractive() {
        return this.fInteractive;
    }

    public boolean isRemoved() {
        return this.fRemoved;
    }

    public void setErrReady(boolean errReady) {
        this.fErrReady = errReady;
    }

    public void setOid(String oid) {
        this.fOid = oid;
    }

    public void setOutReady(boolean outReady) {
        this.fOutReady = outReady;
    }

    public void setRemoved() {
        this.fRemoved = true;
    }

    public void setState(String state) {
        this.fState = state;
    }

    public void setStateDetail(String stateDetail) {
        this.fStateDetail = stateDetail;
        this.fOutReady = this.fOutputPath != null && JOB_OUTERR_READY.equals(stateDetail);
        this.fErrReady = this.fErrorPath != null && JOB_OUTERR_READY.equals(stateDetail);
    }

    public void updateState(String state, String stateDetail) {
        if (!JobStatusData.detailIsFinal(this.fStateDetail)) {
            this.fState = state;
            this.setStateDetail(stateDetail);
        }
    }
}

