/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.core.elements.InfoType;
import org.eclipse.ptp.rm.lml.internal.core.elements.InformationType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIDToInformation
extends LguiHandler {
    private HashMap<String, List<InfoType>> oidtoinfo;

    public OIDToInformation(ILguiItem psuperHandler, LguiType model) {
        super(psuperHandler, model);
        this.updateData(model);
        this.lguiItem.addListener(new ILguiListener(){

            public void handleEvent(ILguiUpdatedEvent e) {
                OIDToInformation.this.updateData(e.getLgui());
            }
        });
    }

    public InfoType getInfoByOid(String oid) {
        List<InformationType> listInformation = this.lguiItem.getOverviewAccess().getInformations();
        for (InformationType information : listInformation) {
            List<InfoType> listInfo = information.getInfo();
            for (InfoType info : listInfo) {
                if (!info.getOid().equals(oid)) continue;
                return info;
            }
        }
        return null;
    }

    public List<InfoType> getInfosById(String id) {
        return this.oidtoinfo.get(id);
    }

    public List<InfoType> getInfosByType(String id, String type) {
        List<InfoType> allinfos = this.getInfosById(id);
        if (allinfos == null) {
            return null;
        }
        ArrayList<InfoType> res = new ArrayList<InfoType>();
        for (InfoType ainfo : allinfos) {
            if (!ainfo.getType().equals(type)) continue;
            res.add(ainfo);
        }
        return res;
    }

    public void updateData(LguiType pmodel) {
        this.lgui = pmodel;
        this.getInformationFromModel();
    }

    private void getInformationFromModel() {
        this.oidtoinfo = new HashMap();
        for (Object object : jaxbUtil.getObjects(this.lgui)) {
            if (!(object instanceof InformationType)) continue;
            InformationType ainfos = (InformationType)object;
            List<InfoType> realinfos = ainfos.getInfo();
            for (InfoType ainfo : realinfos) {
                String oid = ainfo.getOid();
                if (this.oidtoinfo.containsKey(oid)) {
                    List<InfoType> oldlist = this.oidtoinfo.get(oid);
                    oldlist.add(ainfo);
                    continue;
                }
                ArrayList<InfoType> newlist = new ArrayList<InfoType>();
                newlist.add(ainfo);
                this.oidtoinfo.put(oid, newlist);
            }
        }
    }
}

